/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ContextDescriptorCondition;
import com.espertech.esper.common.client.soda.EPStatementFormatter;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.List;

public class ContextDescriptorConditionCrontab
implements ContextDescriptorCondition {
    private static final long serialVersionUID = 5676956299459269157L;
    private List<List<Expression>> crontabExpressions;
    private boolean now;

    public ContextDescriptorConditionCrontab() {
    }

    public ContextDescriptorConditionCrontab(List<List<Expression>> crontabExpressions, boolean now) {
        this.crontabExpressions = crontabExpressions;
        this.now = now;
    }

    public List<List<Expression>> getCrontabExpressions() {
        return this.crontabExpressions;
    }

    public void setCrontabExpressions(List<List<Expression>> crontabExpressions) {
        this.crontabExpressions = crontabExpressions;
    }

    @Override
    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        ContextDescriptorConditionCrontab.write(writer, this.crontabExpressions, this.now);
    }

    public boolean isNow() {
        return this.now;
    }

    public void setNow(boolean now) {
        this.now = now;
    }

    private static void write(StringWriter writer, List<List<Expression>> crontabs, boolean now) {
        if (now) {
            writer.append("@now and ");
        }
        String delimiter = "";
        for (List<Expression> crontab : crontabs) {
            writer.append(delimiter);
            ContextDescriptorConditionCrontab.write(writer, crontab);
            delimiter = ", ";
        }
    }

    private static void write(StringWriter writer, List<Expression> expressions) {
        writer.append("(");
        String delimiter = "";
        for (Expression e : expressions) {
            writer.append(delimiter);
            e.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
        writer.append(")");
    }
}

