/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.Serializable;
import java.io.StringWriter;

public class CreateVariableClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String variableType;
    private String variableName;
    private Expression optionalAssignment;
    private boolean constant;

    public CreateVariableClause() {
    }

    public CreateVariableClause(String variableName) {
        this.variableName = variableName;
    }

    public static CreateVariableClause create(String variableType, String variableName) {
        return new CreateVariableClause(variableType, variableName, null, false);
    }

    public static CreateVariableClause create(String variableType, String variableName, Expression expression) {
        return new CreateVariableClause(variableType, variableName, expression, false);
    }

    public CreateVariableClause(String variableType, String variableName, Expression optionalAssignment, boolean constant) {
        this.variableType = variableType;
        this.variableName = variableName;
        this.optionalAssignment = optionalAssignment;
        this.constant = constant;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public void setVariableType(String variableType) {
        this.variableType = variableType;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public Expression getOptionalAssignment() {
        return this.optionalAssignment;
    }

    public void setOptionalAssignment(Expression optionalAssignment) {
        this.optionalAssignment = optionalAssignment;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public void toEPL(StringWriter writer) {
        writer.append("create");
        if (this.constant) {
            writer.append(" constant");
        }
        writer.append(" variable ");
        if (this.variableType != null) {
            writer.append(this.variableType);
            writer.append(" ");
        }
        writer.append(this.variableName);
        if (this.optionalAssignment != null) {
            writer.append(" = ");
            this.optionalAssignment.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
    }
}

