/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import java.io.StringWriter;

public class EPStatementFormatter {
    private static final String SYSTEM_NEWLINE = System.getProperty("line.separator");
    private static final String SPACE = " ";
    private final boolean isNewline;
    private final String newlineString;
    private String delimiter;

    public EPStatementFormatter() {
        this.isNewline = false;
        this.newlineString = SPACE;
    }

    public EPStatementFormatter(boolean newline) {
        this.isNewline = newline;
        this.newlineString = SYSTEM_NEWLINE;
    }

    public EPStatementFormatter(String newlineString) {
        this.isNewline = true;
        this.newlineString = newlineString;
    }

    public void beginContext(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginAnnotation(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginExpressionDecl(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginInsertInto(StringWriter writer, boolean topLevel) {
        this.writeDelimiter(writer, topLevel);
    }

    public void beginFromStream(StringWriter writer, boolean first) {
        this.writeDelimiter(writer, !first);
    }

    public void beginWhere(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginGroupBy(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginHaving(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginOutput(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginOrderBy(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginLimit(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginFor(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginOnTrigger(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginSelect(StringWriter writer, boolean topLevel) {
        if (topLevel) {
            this.writeDelimiter(writer, topLevel);
        }
        this.setDelimiter();
    }

    public void beginMerge(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginFrom(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginMergeWhere(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginMergeWhenMatched(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginMergeAction(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginOnSet(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginOnDelete(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginOnUpdate(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    private void setDelimiter() {
        this.delimiter = this.isNewline ? this.newlineString : SPACE;
    }

    private void writeDelimiter(StringWriter writer) {
        if (this.delimiter != null) {
            writer.write(this.delimiter);
        }
        this.setDelimiter();
    }

    private void writeDelimiter(StringWriter writer, boolean topLevel) {
        if (this.delimiter != null) {
            if (!topLevel) {
                writer.write(SPACE);
            } else {
                writer.write(this.delimiter);
            }
        }
        this.setDelimiter();
    }

    public void beginCreateDataFlow(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginCreateVariable(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginUpdate(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginCreateWindow(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginCreateContext(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginCreateSchema(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginCreateIndex(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginDataFlowSchema(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginDataFlowOperator(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginDataFlowOperatorDetails(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void endDataFlowOperatorConfig(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void endDataFlowOperatorDetails(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginCreateExpression(StringWriter writer) {
        this.writeDelimiter(writer);
    }

    public void beginCreateTable(StringWriter writer) {
        this.writeDelimiter(writer);
    }
}

