/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.AnnotationPart;
import com.espertech.esper.common.client.soda.CreateContextClause;
import com.espertech.esper.common.client.soda.CreateDataFlowClause;
import com.espertech.esper.common.client.soda.CreateExpressionClause;
import com.espertech.esper.common.client.soda.CreateIndexClause;
import com.espertech.esper.common.client.soda.CreateSchemaClause;
import com.espertech.esper.common.client.soda.CreateTableClause;
import com.espertech.esper.common.client.soda.CreateVariableClause;
import com.espertech.esper.common.client.soda.CreateWindowClause;
import com.espertech.esper.common.client.soda.EPStatementFormatter;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionDeclaration;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.FireAndForgetClause;
import com.espertech.esper.common.client.soda.FireAndForgetDelete;
import com.espertech.esper.common.client.soda.FireAndForgetInsert;
import com.espertech.esper.common.client.soda.FireAndForgetUpdate;
import com.espertech.esper.common.client.soda.ForClause;
import com.espertech.esper.common.client.soda.FromClause;
import com.espertech.esper.common.client.soda.GroupByClause;
import com.espertech.esper.common.client.soda.InsertIntoClause;
import com.espertech.esper.common.client.soda.IntoTableClause;
import com.espertech.esper.common.client.soda.MatchRecognizeClause;
import com.espertech.esper.common.client.soda.OnClause;
import com.espertech.esper.common.client.soda.OnDeleteClause;
import com.espertech.esper.common.client.soda.OnInsertSplitStreamClause;
import com.espertech.esper.common.client.soda.OnMergeClause;
import com.espertech.esper.common.client.soda.OnSelectClause;
import com.espertech.esper.common.client.soda.OnSetClause;
import com.espertech.esper.common.client.soda.OnUpdateClause;
import com.espertech.esper.common.client.soda.OrderByClause;
import com.espertech.esper.common.client.soda.OutputLimitClause;
import com.espertech.esper.common.client.soda.RowLimitClause;
import com.espertech.esper.common.client.soda.ScriptExpression;
import com.espertech.esper.common.client.soda.SelectClause;
import com.espertech.esper.common.client.soda.SelectClauseElement;
import com.espertech.esper.common.client.soda.UpdateClause;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

public class EPStatementObjectModel
implements Serializable {
    private static final long serialVersionUID = 0L;
    private List<AnnotationPart> annotations;
    private List<ExpressionDeclaration> expressionDeclarations;
    private List<ScriptExpression> scriptExpressions;
    private String contextName;
    private UpdateClause updateClause;
    private CreateVariableClause createVariable;
    private CreateTableClause createTable;
    private CreateWindowClause createWindow;
    private CreateIndexClause createIndex;
    private CreateSchemaClause createSchema;
    private CreateContextClause createContext;
    private CreateDataFlowClause createDataFlow;
    private CreateExpressionClause createExpression;
    private OnClause onExpr;
    private InsertIntoClause insertInto;
    private SelectClause selectClause;
    private FromClause fromClause;
    private Expression whereClause;
    private GroupByClause groupByClause;
    private Expression havingClause;
    private OutputLimitClause outputLimitClause;
    private OrderByClause orderByClause;
    private RowLimitClause rowLimitClause;
    private MatchRecognizeClause matchRecognizeClause;
    private ForClause forClause;
    private String treeObjectName;
    private FireAndForgetClause fireAndForgetClause;
    private IntoTableClause intoTableClause;

    public void setInsertInto(InsertIntoClause insertInto) {
        this.insertInto = insertInto;
    }

    public EPStatementObjectModel insertInto(InsertIntoClause insertInto) {
        this.insertInto = insertInto;
        return this;
    }

    public InsertIntoClause getInsertInto() {
        return this.insertInto;
    }

    public void setSelectClause(SelectClause selectClause) {
        this.selectClause = selectClause;
    }

    public EPStatementObjectModel selectClause(SelectClause selectClause) {
        this.selectClause = selectClause;
        return this;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public void setFromClause(FromClause fromClause) {
        this.fromClause = fromClause;
    }

    public EPStatementObjectModel fromClause(FromClause fromClause) {
        this.fromClause = fromClause;
        return this;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(Expression whereClause) {
        this.whereClause = whereClause;
    }

    public EPStatementObjectModel whereClause(Expression whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public GroupByClause getGroupByClause() {
        return this.groupByClause;
    }

    public void setGroupByClause(GroupByClause groupByClause) {
        this.groupByClause = groupByClause;
    }

    public EPStatementObjectModel groupByClause(GroupByClause groupByClause) {
        this.groupByClause = groupByClause;
        return this;
    }

    public Expression getHavingClause() {
        return this.havingClause;
    }

    public void setHavingClause(Expression havingClause) {
        this.havingClause = havingClause;
    }

    public EPStatementObjectModel havingClause(Expression havingClause) {
        this.havingClause = havingClause;
        return this;
    }

    public OrderByClause getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(OrderByClause orderByClause) {
        this.orderByClause = orderByClause;
    }

    public EPStatementObjectModel orderByClause(OrderByClause orderByClause) {
        this.orderByClause = orderByClause;
        return this;
    }

    public OutputLimitClause getOutputLimitClause() {
        return this.outputLimitClause;
    }

    public void setOutputLimitClause(OutputLimitClause outputLimitClause) {
        this.outputLimitClause = outputLimitClause;
    }

    public EPStatementObjectModel outputLimitClause(OutputLimitClause outputLimitClause) {
        this.outputLimitClause = outputLimitClause;
        return this;
    }

    public String toEPL() {
        StringWriter writer = new StringWriter();
        this.toEPL(new EPStatementFormatter(false), writer);
        return writer.toString();
    }

    public void toEPL(StringWriter writer) {
        this.toEPL(new EPStatementFormatter(false), writer);
    }

    public String toEPL(EPStatementFormatter formatter) {
        StringWriter writer = new StringWriter();
        this.toEPL(formatter, writer);
        return writer.toString();
    }

    public void toEPL(EPStatementFormatter formatter, StringWriter writer) {
        AnnotationPart.toEPL(writer, this.annotations, formatter);
        ExpressionDeclaration.toEPL(writer, this.expressionDeclarations, formatter);
        ScriptExpression.toEPL(writer, this.scriptExpressions, formatter);
        if (this.contextName != null) {
            formatter.beginContext(writer);
            writer.append("context ");
            writer.append(this.contextName);
        }
        if (this.createIndex != null) {
            formatter.beginCreateIndex(writer);
            this.createIndex.toEPL(writer);
            return;
        }
        if (this.createSchema != null) {
            formatter.beginCreateSchema(writer);
            this.createSchema.toEPL(writer);
            return;
        }
        if (this.createExpression != null) {
            formatter.beginCreateExpression(writer);
            this.createExpression.toEPL(writer);
            return;
        }
        if (this.createContext != null) {
            formatter.beginCreateContext(writer);
            this.createContext.toEPL(writer, formatter);
            return;
        }
        if (this.createWindow != null) {
            formatter.beginCreateWindow(writer);
            this.createWindow.toEPL(writer);
            writer.write(" as ");
            if (this.selectClause == null || this.selectClause.getSelectList().isEmpty() && !this.createWindow.getColumns().isEmpty()) {
                this.createWindow.toEPLCreateTablePart(writer);
            } else {
                this.selectClause.toEPL(writer, formatter, false, false);
                if (this.createWindow.getAsEventTypeName() != null) {
                    writer.append(" from ");
                    writer.append(this.createWindow.getAsEventTypeName());
                }
                this.createWindow.toEPLInsertPart(writer);
            }
            return;
        }
        if (this.createVariable != null) {
            formatter.beginCreateVariable(writer);
            this.createVariable.toEPL(writer);
            return;
        }
        if (this.createTable != null) {
            formatter.beginCreateTable(writer);
            this.createTable.toEPL(writer);
            return;
        }
        if (this.createDataFlow != null) {
            formatter.beginCreateDataFlow(writer);
            this.createDataFlow.toEPL(writer, formatter);
            return;
        }
        boolean displayWhereClause = true;
        if (this.updateClause != null) {
            formatter.beginUpdate(writer);
            this.updateClause.toEPL(writer);
        } else if (this.onExpr != null) {
            formatter.beginOnTrigger(writer);
            writer.write("on ");
            this.fromClause.getStreams().get(0).toEPL(writer, formatter);
            if (this.onExpr instanceof OnDeleteClause) {
                formatter.beginOnDelete(writer);
                writer.write("delete from ");
                ((OnDeleteClause)this.onExpr).toEPL(writer);
            } else if (this.onExpr instanceof OnUpdateClause) {
                formatter.beginOnUpdate(writer);
                writer.write("update ");
                ((OnUpdateClause)this.onExpr).toEPL(writer);
            } else if (this.onExpr instanceof OnSelectClause) {
                OnSelectClause onSelect = (OnSelectClause)this.onExpr;
                if (this.insertInto != null) {
                    this.insertInto.toEPL(writer, formatter, true);
                }
                this.selectClause.toEPL(writer, formatter, true, onSelect.isDeleteAndSelect());
                writer.write(" from ");
                onSelect.toEPL(writer);
            } else if (this.onExpr instanceof OnSetClause) {
                OnSetClause onSet = (OnSetClause)this.onExpr;
                onSet.toEPL(writer, formatter);
            } else if (this.onExpr instanceof OnMergeClause) {
                OnMergeClause merge = (OnMergeClause)this.onExpr;
                merge.toEPL(writer, this.whereClause, formatter);
                displayWhereClause = false;
            } else {
                OnInsertSplitStreamClause split = (OnInsertSplitStreamClause)this.onExpr;
                this.insertInto.toEPL(writer, formatter, true);
                this.selectClause.toEPL(writer, formatter, true, false);
                if (this.whereClause != null) {
                    writer.write(" where ");
                    this.whereClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                }
                split.toEPL(writer, formatter);
                displayWhereClause = false;
            }
        } else {
            if (this.intoTableClause != null) {
                this.intoTableClause.toEPL(writer);
            }
            if (this.selectClause == null) {
                throw new IllegalStateException("Select-clause has not been defined");
            }
            if (this.fromClause == null) {
                throw new IllegalStateException("From-clause has not been defined");
            }
            if (this.fireAndForgetClause instanceof FireAndForgetUpdate) {
                FireAndForgetUpdate update = (FireAndForgetUpdate)this.fireAndForgetClause;
                writer.append("update ");
                this.fromClause.toEPLOptions(writer, formatter, false);
                writer.append(" ");
                UpdateClause.renderEPLAssignments(writer, update.getAssignments());
            } else if (this.fireAndForgetClause instanceof FireAndForgetInsert) {
                FireAndForgetInsert insert = (FireAndForgetInsert)this.fireAndForgetClause;
                this.insertInto.toEPL(writer, formatter, true);
                if (insert.isUseValuesKeyword()) {
                    writer.append(" values (");
                    String delimiter = "";
                    for (SelectClauseElement element : this.selectClause.getSelectList()) {
                        writer.write(delimiter);
                        element.toEPLElement(writer);
                        delimiter = ", ";
                    }
                    writer.append(")");
                } else {
                    this.selectClause.toEPL(writer, formatter, true, false);
                }
            } else if (this.fireAndForgetClause instanceof FireAndForgetDelete) {
                writer.append("delete ");
                this.fromClause.toEPLOptions(writer, formatter, true);
            } else {
                if (this.insertInto != null) {
                    this.insertInto.toEPL(writer, formatter, true);
                }
                this.selectClause.toEPL(writer, formatter, true, false);
                this.fromClause.toEPLOptions(writer, formatter, true);
            }
        }
        if (this.matchRecognizeClause != null) {
            this.matchRecognizeClause.toEPL(writer);
        }
        if (this.whereClause != null && displayWhereClause) {
            formatter.beginWhere(writer);
            writer.write("where ");
            this.whereClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        if (this.groupByClause != null) {
            formatter.beginGroupBy(writer);
            writer.write("group by ");
            this.groupByClause.toEPL(writer);
        }
        if (this.havingClause != null) {
            formatter.beginHaving(writer);
            writer.write("having ");
            this.havingClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        if (this.outputLimitClause != null) {
            formatter.beginOutput(writer);
            writer.write("output ");
            this.outputLimitClause.toEPL(writer);
        }
        if (this.orderByClause != null) {
            formatter.beginOrderBy(writer);
            writer.write("order by ");
            this.orderByClause.toEPL(writer);
        }
        if (this.rowLimitClause != null) {
            formatter.beginLimit(writer);
            writer.write("limit ");
            this.rowLimitClause.toEPL(writer);
        }
        if (this.forClause != null) {
            formatter.beginFor(writer);
            this.forClause.toEPL(writer);
        }
    }

    public CreateWindowClause getCreateWindow() {
        return this.createWindow;
    }

    public void setCreateWindow(CreateWindowClause createWindow) {
        this.createWindow = createWindow;
    }

    public OnClause getOnExpr() {
        return this.onExpr;
    }

    public void setOnExpr(OnClause onExpr) {
        this.onExpr = onExpr;
    }

    public CreateVariableClause getCreateVariable() {
        return this.createVariable;
    }

    public void setCreateVariable(CreateVariableClause createVariable) {
        this.createVariable = createVariable;
    }

    public RowLimitClause getRowLimitClause() {
        return this.rowLimitClause;
    }

    public void setRowLimitClause(RowLimitClause rowLimitClause) {
        this.rowLimitClause = rowLimitClause;
    }

    public UpdateClause getUpdateClause() {
        return this.updateClause;
    }

    public void setUpdateClause(UpdateClause updateClause) {
        this.updateClause = updateClause;
    }

    public List<AnnotationPart> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationPart> annotations) {
        this.annotations = annotations;
    }

    public MatchRecognizeClause getMatchRecognizeClause() {
        return this.matchRecognizeClause;
    }

    public void setMatchRecognizeClause(MatchRecognizeClause clause) {
        this.matchRecognizeClause = clause;
    }

    public CreateIndexClause getCreateIndex() {
        return this.createIndex;
    }

    public void setCreateIndex(CreateIndexClause createIndex) {
        this.createIndex = createIndex;
    }

    public CreateSchemaClause getCreateSchema() {
        return this.createSchema;
    }

    public void setCreateSchema(CreateSchemaClause createSchema) {
        this.createSchema = createSchema;
    }

    public CreateContextClause getCreateContext() {
        return this.createContext;
    }

    public void setCreateContext(CreateContextClause createContext) {
        this.createContext = createContext;
    }

    public ForClause getForClause() {
        return this.forClause;
    }

    public void setForClause(ForClause forClause) {
        this.forClause = forClause;
    }

    public List<ExpressionDeclaration> getExpressionDeclarations() {
        return this.expressionDeclarations;
    }

    public void setExpressionDeclarations(List<ExpressionDeclaration> expressionDeclarations) {
        this.expressionDeclarations = expressionDeclarations;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public List<ScriptExpression> getScriptExpressions() {
        return this.scriptExpressions;
    }

    public void setScriptExpressions(List<ScriptExpression> scriptExpressions) {
        this.scriptExpressions = scriptExpressions;
    }

    public CreateDataFlowClause getCreateDataFlow() {
        return this.createDataFlow;
    }

    public void setCreateDataFlow(CreateDataFlowClause createDataFlow) {
        this.createDataFlow = createDataFlow;
    }

    public String getTreeObjectName() {
        return this.treeObjectName;
    }

    public void setTreeObjectName(String treeObjectName) {
        this.treeObjectName = treeObjectName;
    }

    public CreateExpressionClause getCreateExpression() {
        return this.createExpression;
    }

    public void setCreateExpression(CreateExpressionClause createExpression) {
        this.createExpression = createExpression;
    }

    public FireAndForgetClause getFireAndForgetClause() {
        return this.fireAndForgetClause;
    }

    public void setFireAndForgetClause(FireAndForgetClause fireAndForgetClause) {
        this.fireAndForgetClause = fireAndForgetClause;
    }

    public IntoTableClause getIntoTableClause() {
        return this.intoTableClause;
    }

    public void setIntoTableClause(IntoTableClause intoTableClause) {
        this.intoTableClause = intoTableClause;
    }

    public CreateTableClause getCreateTable() {
        return this.createTable;
    }

    public void setCreateTable(CreateTableClause createTable) {
        this.createTable = createTable;
    }
}

