/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;

public class InstanceOfExpression
extends ExpressionBase {
    private String[] typeNames;
    private static final long serialVersionUID = 237629474193131995L;

    public InstanceOfExpression() {
    }

    public InstanceOfExpression(String[] typeNames) {
        this.typeNames = typeNames;
    }

    public InstanceOfExpression(Expression expressionToCheck, String typeName, String ... moreTypes) {
        this.getChildren().add(expressionToCheck);
        if (moreTypes == null) {
            this.typeNames = new String[]{typeName};
        } else {
            this.typeNames = new String[moreTypes.length + 1];
            this.typeNames[0] = typeName;
            System.arraycopy(moreTypes, 0, this.typeNames, 1, moreTypes.length);
        }
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write("instanceof(");
        this.getChildren().get(0).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        writer.write(",");
        String delimiter = "";
        for (String typeName : this.typeNames) {
            writer.write(delimiter);
            writer.write(typeName);
            delimiter = ",";
        }
        writer.write(")");
    }

    public String[] getTypeNames() {
        return this.typeNames;
    }

    public void setTypeNames(String[] typeNames) {
        this.typeNames = typeNames;
    }
}

