/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ExpressionBase;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.List;

public class LambdaExpression
extends ExpressionBase {
    private static final long serialVersionUID = 353451331713297154L;
    private List<String> parameters;

    public LambdaExpression() {
    }

    public LambdaExpression(List<String> parameters) {
        this.parameters = parameters;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.MINIMUM;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.parameters.size() > 1) {
            writer.append("(");
            String delimiter = "";
            for (String parameter : this.parameters) {
                writer.append(delimiter);
                writer.append(parameter);
                delimiter = ",";
            }
            writer.append(")");
        } else {
            writer.append(this.parameters.get(0));
        }
        writer.append(" => ");
        this.getChildren().get(0).toEPL(writer, this.getPrecedence());
    }
}

