/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.Assignment;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.OutputLimitSelector;
import com.espertech.esper.common.client.soda.OutputLimitUnit;
import com.espertech.esper.common.client.soda.TimePeriodExpression;
import com.espertech.esper.common.client.soda.UpdateClause;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class OutputLimitClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private OutputLimitSelector selector;
    private Double frequency;
    private String frequencyVariable;
    private OutputLimitUnit unit;
    private Expression whenExpression;
    private List<Assignment> thenAssignments;
    private Expression[] crontabAtParameters;
    private Expression timePeriodExpression;
    private Expression afterTimePeriodExpression;
    private Integer afterNumberOfEvents;
    private boolean andAfterTerminate;
    private Expression andAfterTerminateAndExpr;
    private List<Assignment> andAfterTerminateThenAssignments;

    public OutputLimitClause() {
    }

    public OutputLimitClause(OutputLimitSelector selector, OutputLimitUnit unit) {
        this.selector = selector;
        this.unit = unit;
    }

    public static OutputLimitClause create(TimePeriodExpression timePeriodExpression) {
        return new OutputLimitClause(OutputLimitSelector.DEFAULT, timePeriodExpression);
    }

    public static OutputLimitClause createAfter(TimePeriodExpression afterTimePeriodExpression) {
        return new OutputLimitClause(OutputLimitSelector.DEFAULT, OutputLimitUnit.AFTER, afterTimePeriodExpression, null);
    }

    public static OutputLimitClause createAfter(int afterNumEvents) {
        return new OutputLimitClause(OutputLimitSelector.DEFAULT, OutputLimitUnit.AFTER, null, afterNumEvents);
    }

    public static OutputLimitClause create(OutputLimitSelector selector, TimePeriodExpression timePeriodExpression) {
        return new OutputLimitClause(selector, timePeriodExpression);
    }

    public static OutputLimitClause create(OutputLimitSelector selector, double frequency) {
        return new OutputLimitClause(selector, frequency);
    }

    public static OutputLimitClause create(OutputLimitSelector selector, String frequencyVariable) {
        return new OutputLimitClause(selector, frequencyVariable);
    }

    public static OutputLimitClause create(double frequency) {
        return new OutputLimitClause(OutputLimitSelector.DEFAULT, frequency);
    }

    public static OutputLimitClause create(String frequencyVariable) {
        return new OutputLimitClause(OutputLimitSelector.DEFAULT, frequencyVariable);
    }

    public static OutputLimitClause create(Expression whenExpression) {
        return new OutputLimitClause(OutputLimitSelector.DEFAULT, whenExpression, new ArrayList<Assignment>());
    }

    public static OutputLimitClause createSchedule(Expression[] scheduleParameters) {
        return new OutputLimitClause(OutputLimitSelector.DEFAULT, scheduleParameters);
    }

    public OutputLimitClause(OutputLimitSelector selector, Double frequency) {
        this.selector = selector;
        this.frequency = frequency;
        this.unit = OutputLimitUnit.EVENTS;
    }

    public OutputLimitClause(OutputLimitSelector selector, TimePeriodExpression timePeriodExpression) {
        this.selector = selector;
        this.timePeriodExpression = timePeriodExpression;
        this.unit = OutputLimitUnit.TIME_PERIOD;
    }

    public OutputLimitClause(TimePeriodExpression afterTimePeriodExpression) {
        this.unit = OutputLimitUnit.AFTER;
        this.afterTimePeriodExpression = afterTimePeriodExpression;
    }

    public OutputLimitClause(OutputLimitSelector selector, String frequencyVariable) {
        this.selector = selector;
        this.frequencyVariable = frequencyVariable;
        this.unit = OutputLimitUnit.EVENTS;
    }

    public OutputLimitClause(OutputLimitSelector selector, Double frequency, String frequencyVariable, OutputLimitUnit unit) {
        this.selector = selector;
        this.frequency = frequency;
        this.frequencyVariable = frequencyVariable;
        this.unit = unit;
    }

    public OutputLimitClause(OutputLimitSelector selector, OutputLimitUnit unit, TimePeriodExpression afterTimePeriod, Integer afterNumberOfEvents) {
        this.selector = selector;
        this.unit = unit;
        this.afterTimePeriodExpression = afterTimePeriod;
        this.afterNumberOfEvents = afterNumberOfEvents;
    }

    public OutputLimitClause(OutputLimitSelector selector, Expression[] crontabAtParameters) {
        this.selector = selector;
        this.crontabAtParameters = crontabAtParameters;
        this.unit = OutputLimitUnit.CRONTAB_EXPRESSION;
    }

    public OutputLimitClause(OutputLimitSelector selector, Expression whenExpression, List<Assignment> thenAssignments) {
        this.selector = selector;
        this.whenExpression = whenExpression;
        this.thenAssignments = thenAssignments;
        this.unit = OutputLimitUnit.WHEN_EXPRESSION;
    }

    public OutputLimitSelector getSelector() {
        return this.selector;
    }

    public void setSelector(OutputLimitSelector selector) {
        this.selector = selector;
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public OutputLimitUnit getUnit() {
        return this.unit;
    }

    public void setUnit(OutputLimitUnit unit) {
        this.unit = unit;
    }

    public String getFrequencyVariable() {
        return this.frequencyVariable;
    }

    public void setFrequencyVariable(String frequencyVariable) {
        this.frequencyVariable = frequencyVariable;
    }

    public Expression getWhenExpression() {
        return this.whenExpression;
    }

    public Expression getTimePeriodExpression() {
        return this.timePeriodExpression;
    }

    public List<Assignment> getThenAssignments() {
        return this.thenAssignments;
    }

    public OutputLimitClause addThenAssignment(Expression assignmentExpression) {
        this.thenAssignments.add(new Assignment(assignmentExpression));
        return this;
    }

    public Expression[] getCrontabAtParameters() {
        return this.crontabAtParameters;
    }

    public boolean isAndAfterTerminate() {
        return this.andAfterTerminate;
    }

    public void setAndAfterTerminate(boolean andAfterTerminate) {
        this.andAfterTerminate = andAfterTerminate;
    }

    public void toEPL(StringWriter writer) {
        if (this.afterTimePeriodExpression != null) {
            writer.write("after ");
            this.afterTimePeriodExpression.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.write(" ");
        } else if (this.afterNumberOfEvents != null && this.afterNumberOfEvents != 0) {
            writer.write("after ");
            writer.write(Integer.toString(this.afterNumberOfEvents));
            writer.write(" events ");
        }
        if (this.selector != OutputLimitSelector.DEFAULT) {
            writer.write(this.selector.getText());
            writer.write(" ");
        }
        if (this.unit == OutputLimitUnit.WHEN_EXPRESSION) {
            writer.write("when ");
            this.whenExpression.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            if (this.thenAssignments != null && this.thenAssignments.size() > 0) {
                this.writeThenAssignments(writer, this.thenAssignments);
            }
        } else if (this.unit == OutputLimitUnit.CRONTAB_EXPRESSION) {
            writer.write("at (");
            String delimiter = "";
            for (int i = 0; i < this.crontabAtParameters.length; ++i) {
                writer.write(delimiter);
                this.crontabAtParameters[i].toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                delimiter = ", ";
            }
            writer.write(")");
        } else if (this.unit == OutputLimitUnit.TIME_PERIOD && this.timePeriodExpression != null) {
            writer.write("every ");
            this.timePeriodExpression.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        } else if (this.unit != OutputLimitUnit.AFTER) {
            if (this.unit == OutputLimitUnit.CONTEXT_PARTITION_TERM) {
                writer.write("when terminated");
                this.outputAndAfter(writer);
            } else {
                writer.write("every ");
                if (this.frequencyVariable == null) {
                    writer.write(Integer.toString(this.frequency.intValue()));
                } else {
                    writer.write(this.frequencyVariable);
                }
                writer.write(" events");
            }
        }
        if (this.andAfterTerminate) {
            writer.write(" and when terminated");
            this.outputAndAfter(writer);
        }
    }

    public Expression getAfterTimePeriodExpression() {
        return this.afterTimePeriodExpression;
    }

    public void setAfterTimePeriodExpression(Expression afterTimePeriodExpression) {
        this.afterTimePeriodExpression = afterTimePeriodExpression;
    }

    public OutputLimitClause afterTimePeriodExpression(TimePeriodExpression afterTimePeriodExpression) {
        this.afterTimePeriodExpression = afterTimePeriodExpression;
        return this;
    }

    public Integer getAfterNumberOfEvents() {
        return this.afterNumberOfEvents;
    }

    public void setFrequency(Double frequency) {
        this.frequency = frequency;
    }

    public void setWhenExpression(Expression whenExpression) {
        this.whenExpression = whenExpression;
    }

    public void setThenAssignments(List<Assignment> thenAssignments) {
        this.thenAssignments = thenAssignments;
    }

    public void setCrontabAtParameters(Expression[] crontabAtParameters) {
        this.crontabAtParameters = crontabAtParameters;
    }

    public void setTimePeriodExpression(Expression timePeriodExpression) {
        this.timePeriodExpression = timePeriodExpression;
    }

    public void setAfterNumberOfEvents(Integer afterNumberOfEvents) {
        this.afterNumberOfEvents = afterNumberOfEvents;
    }

    public OutputLimitClause afterNumberOfEvents(Integer afterNumberOfEvents) {
        this.afterNumberOfEvents = afterNumberOfEvents;
        return this;
    }

    public Expression getAndAfterTerminateAndExpr() {
        return this.andAfterTerminateAndExpr;
    }

    public void setAndAfterTerminateAndExpr(Expression andAfterTerminateAndExpr) {
        this.andAfterTerminateAndExpr = andAfterTerminateAndExpr;
    }

    public List<Assignment> getAndAfterTerminateThenAssignments() {
        return this.andAfterTerminateThenAssignments;
    }

    public void setAndAfterTerminateThenAssignments(List<Assignment> andAfterTerminateThenAssignments) {
        this.andAfterTerminateThenAssignments = andAfterTerminateThenAssignments;
    }

    private void writeThenAssignments(StringWriter writer, List<Assignment> thenAssignments) {
        writer.write(" then ");
        UpdateClause.renderEPLAssignments(writer, thenAssignments);
    }

    private void outputAndAfter(StringWriter writer) {
        if (this.andAfterTerminateAndExpr != null) {
            writer.write(" and ");
            this.andAfterTerminateAndExpr.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        if (this.andAfterTerminateThenAssignments != null && this.andAfterTerminateThenAssignments.size() > 0) {
            this.writeThenAssignments(writer, this.andAfterTerminateThenAssignments);
        }
    }
}

