/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.EPStatementFormatter;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.PatternExprBase;
import com.espertech.esper.common.client.soda.PatternExprPrecedenceEnum;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class PatternEveryDistinctExpr
extends PatternExprBase {
    private static final long serialVersionUID = 0L;
    private List<Expression> expressions = new ArrayList<Expression>();

    public PatternEveryDistinctExpr() {
    }

    public PatternEveryDistinctExpr(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public PatternExprPrecedenceEnum getPrecedence() {
        return PatternExprPrecedenceEnum.EVERY_NOT;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, EPStatementFormatter formatter) {
        writer.write("every-distinct(");
        String delimiter = "";
        for (Expression expr : this.expressions) {
            writer.write(delimiter);
            expr.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
        writer.write(") ");
        this.getChildren().get(0).toEPL(writer, this.getPrecedence(), formatter);
    }
}

