/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.EPStatementFormatter;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.PatternExpr;
import com.espertech.esper.common.client.soda.PatternExprBase;
import com.espertech.esper.common.client.soda.PatternExprPrecedenceEnum;
import java.io.StringWriter;
import java.util.List;

public class PatternFollowedByExpr
extends PatternExprBase {
    private static final long serialVersionUID = 1480442602208180240L;
    private List<Expression> optionalMaxPerSubexpression;

    public PatternFollowedByExpr() {
    }

    public PatternFollowedByExpr(List<Expression> optionalMaxPerSubexpression) {
        this.optionalMaxPerSubexpression = optionalMaxPerSubexpression;
    }

    public PatternFollowedByExpr(PatternExpr first, PatternExpr second, PatternExpr ... patternExprs) {
        this.addChild(first);
        this.addChild(second);
        for (int i = 0; i < patternExprs.length; ++i) {
            this.addChild(patternExprs[i]);
        }
    }

    public PatternFollowedByExpr add(PatternExpr expr) {
        this.getChildren().add(expr);
        return this;
    }

    @Override
    public PatternExprPrecedenceEnum getPrecedence() {
        return PatternExprPrecedenceEnum.FOLLOWED_BY;
    }

    public List<Expression> getOptionalMaxPerSubexpression() {
        return this.optionalMaxPerSubexpression;
    }

    public void setOptionalMaxPerSubexpression(List<Expression> optionalMaxPerSubexpression) {
        this.optionalMaxPerSubexpression = optionalMaxPerSubexpression;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, EPStatementFormatter formatter) {
        String delimiter = "";
        int childNum = 0;
        for (PatternExpr child : this.getChildren()) {
            Expression maxExpr;
            writer.write(delimiter);
            child.toEPL(writer, this.getPrecedence(), formatter);
            delimiter = " -> ";
            if (this.optionalMaxPerSubexpression != null && this.optionalMaxPerSubexpression.size() > childNum && (maxExpr = this.optionalMaxPerSubexpression.get(childNum)) != null) {
                StringWriter inner = new StringWriter();
                maxExpr.toEPL(inner, ExpressionPrecedenceEnum.MINIMUM);
                delimiter = " -[" + inner.toString() + "]> ";
            }
            ++childNum;
        }
    }
}

