/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.EPStatementFormatter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

public class ScriptExpression
implements Serializable {
    private static final long serialVersionUID = 3264067514571908258L;
    private String name;
    private List<String> parameterNames;
    private String expressionText;
    private String optionalReturnType;
    private String optionalEventTypeName;
    private String optionalDialect;

    public ScriptExpression() {
    }

    public ScriptExpression(String name, List<String> parameterNames, String expressionText, String optionalReturnType, String optionalDialect, String optionalEventTypeName) {
        this.name = name;
        this.parameterNames = parameterNames;
        this.expressionText = expressionText;
        this.optionalReturnType = optionalReturnType;
        this.optionalDialect = optionalDialect;
        this.optionalEventTypeName = optionalEventTypeName;
    }

    public ScriptExpression(String name, List<String> parameterNames, String expressionText, String optionalReturnType, String optionalDialect) {
        this(name, parameterNames, expressionText, optionalReturnType, optionalDialect, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOptionalReturnType() {
        return this.optionalReturnType;
    }

    public void setOptionalReturnType(String optionalReturnType) {
        this.optionalReturnType = optionalReturnType;
    }

    public String getOptionalDialect() {
        return this.optionalDialect;
    }

    public void setOptionalDialect(String optionalDialect) {
        this.optionalDialect = optionalDialect;
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    public void setExpressionText(String expressionText) {
        this.expressionText = expressionText;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }

    public String getOptionalEventTypeName() {
        return this.optionalEventTypeName;
    }

    public void setOptionalEventTypeName(String optionalEventTypeName) {
        this.optionalEventTypeName = optionalEventTypeName;
    }

    public static void toEPL(StringWriter writer, List<ScriptExpression> scripts, EPStatementFormatter formatter) {
        if (scripts == null || scripts.isEmpty()) {
            return;
        }
        for (ScriptExpression part : scripts) {
            if (part.getName() == null) continue;
            formatter.beginExpressionDecl(writer);
            part.toEPL(writer);
        }
    }

    public void toEPL(StringWriter writer) {
        writer.append("expression ");
        if (this.optionalReturnType != null) {
            writer.append(this.optionalReturnType);
            writer.append(" ");
        }
        if (this.optionalEventTypeName != null) {
            writer.append("@type(");
            writer.append(this.optionalEventTypeName);
            writer.append(") ");
        }
        if (this.optionalDialect != null && this.optionalDialect.trim().length() != 0) {
            writer.append(this.optionalDialect);
            writer.append(":");
        }
        writer.append(this.name);
        writer.append("(");
        if (this.parameterNames != null && !this.parameterNames.isEmpty()) {
            String delimiter = "";
            for (String name : this.parameterNames) {
                writer.append(delimiter);
                writer.append(name);
                delimiter = ",";
            }
        }
        writer.append(")");
        writer.append(" [");
        writer.append(this.expressionText);
        writer.append("]");
    }
}

