/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.EPStatementFormatter;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.PropertyValueExpression;
import com.espertech.esper.common.client.soda.SelectClauseElement;
import com.espertech.esper.common.client.soda.SelectClauseExpression;
import com.espertech.esper.common.client.soda.SelectClauseStreamWildcard;
import com.espertech.esper.common.client.soda.SelectClauseWildcard;
import com.espertech.esper.common.client.soda.StreamSelector;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class SelectClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private boolean distinct;
    private StreamSelector streamSelector;
    private List<SelectClauseElement> selectList;

    public SelectClause() {
    }

    public static SelectClause createWildcard() {
        ArrayList<SelectClauseElement> selectList = new ArrayList<SelectClauseElement>();
        selectList.add(new SelectClauseWildcard());
        return new SelectClause(StreamSelector.ISTREAM_ONLY, selectList);
    }

    public static SelectClause create() {
        return new SelectClause(StreamSelector.ISTREAM_ONLY, new ArrayList<SelectClauseElement>());
    }

    public static SelectClause create(String ... propertyNames) {
        ArrayList<SelectClauseElement> selectList = new ArrayList<SelectClauseElement>();
        for (String name : propertyNames) {
            selectList.add(new SelectClauseExpression(new PropertyValueExpression(name)));
        }
        return new SelectClause(StreamSelector.ISTREAM_ONLY, selectList);
    }

    public static SelectClause createStreamWildcard(String streamName) {
        ArrayList<SelectClauseElement> selectList = new ArrayList<SelectClauseElement>();
        selectList.add(new SelectClauseStreamWildcard(streamName, null));
        return new SelectClause(StreamSelector.ISTREAM_ONLY, selectList);
    }

    public static SelectClause createWildcard(StreamSelector streamSelector) {
        ArrayList<SelectClauseElement> selectList = new ArrayList<SelectClauseElement>();
        selectList.add(new SelectClauseWildcard());
        return new SelectClause(streamSelector, selectList);
    }

    public static SelectClause create(StreamSelector streamSelector) {
        return new SelectClause(streamSelector, new ArrayList<SelectClauseElement>());
    }

    public static SelectClause create(StreamSelector streamSelector, String ... propertyNames) {
        ArrayList<SelectClauseElement> selectList = new ArrayList<SelectClauseElement>();
        for (String name : propertyNames) {
            selectList.add(new SelectClauseExpression(new PropertyValueExpression(name)));
        }
        return new SelectClause(streamSelector, selectList);
    }

    protected SelectClause(StreamSelector streamSelector, List<SelectClauseElement> selectList) {
        this.streamSelector = streamSelector;
        this.selectList = selectList;
    }

    public SelectClause add(String ... propertyNames) {
        for (String name : propertyNames) {
            this.selectList.add(new SelectClauseExpression(new PropertyValueExpression(name)));
        }
        return this;
    }

    public SelectClause addWithAsProvidedName(String propertyName, String asName) {
        this.selectList.add(new SelectClauseExpression(new PropertyValueExpression(propertyName), asName));
        return this;
    }

    public SelectClause add(Expression expression) {
        this.selectList.add(new SelectClauseExpression(expression));
        return this;
    }

    public SelectClause add(Expression expression, String asName) {
        this.selectList.add(new SelectClauseExpression(expression, asName));
        return this;
    }

    public List<SelectClauseElement> getSelectList() {
        return this.selectList;
    }

    public SelectClause addStreamWildcard(String streamName) {
        this.selectList.add(new SelectClauseStreamWildcard(streamName, null));
        return this;
    }

    public SelectClause addWildcard() {
        this.selectList.add(new SelectClauseWildcard());
        return this;
    }

    public SelectClause addStreamWildcard(String streamName, String columnName) {
        this.selectList.add(new SelectClauseStreamWildcard(streamName, columnName));
        return this;
    }

    public void setStreamSelector(StreamSelector streamSelector) {
        this.streamSelector = streamSelector;
    }

    public SelectClause streamSelector(StreamSelector streamSelector) {
        this.streamSelector = streamSelector;
        return this;
    }

    public StreamSelector getStreamSelector() {
        return this.streamSelector;
    }

    public void setSelectList(List<SelectClauseElement> selectList) {
        this.selectList = selectList;
    }

    public void addElements(List<SelectClauseElement> selectClauseElements) {
        this.selectList.addAll(selectClauseElements);
    }

    public void toEPL(StringWriter writer, EPStatementFormatter formatter, boolean isTopLevel, boolean andDelete) {
        formatter.beginSelect(writer, isTopLevel);
        writer.write("select ");
        if (andDelete) {
            writer.write("and delete ");
        }
        if (this.distinct) {
            writer.write("distinct ");
        }
        if (this.streamSelector != StreamSelector.ISTREAM_ONLY) {
            if (this.streamSelector == StreamSelector.RSTREAM_ONLY) {
                writer.write("rstream ");
            } else if (this.streamSelector == StreamSelector.RSTREAM_ISTREAM_BOTH) {
                writer.write("irstream ");
            }
        }
        if (this.selectList != null && !this.selectList.isEmpty()) {
            String delimiter = "";
            for (SelectClauseElement element : this.selectList) {
                writer.write(delimiter);
                element.toEPLElement(writer);
                delimiter = ", ";
            }
        } else {
            writer.write(42);
        }
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public SelectClause distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public SelectClause distinct() {
        this.distinct = true;
        return this;
    }
}

