/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.base;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenField;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class CodegenSubstitutionParamEntry {
    private final CodegenField field;
    private final String name;
    private final Class type;

    public CodegenSubstitutionParamEntry(CodegenField field, String name, Class type) {
        this.field = field;
        this.name = name;
        this.type = type;
    }

    public CodegenField getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public static void codegenSetterMethod(CodegenClassScope classScope, CodegenMethod method) {
        List<CodegenSubstitutionParamEntry> numbered = classScope.getPackageScope().getSubstitutionParamsByNumber();
        LinkedHashMap<String, CodegenSubstitutionParamEntry> named = classScope.getPackageScope().getSubstitutionParamsByName();
        if (numbered.isEmpty() && named.isEmpty()) {
            return;
        }
        if (!numbered.isEmpty() && !named.isEmpty()) {
            throw new IllegalStateException("Both named and numbered substitution parameters are non-empty");
        }
        List<CodegenSubstitutionParamEntry> fields = !numbered.isEmpty() ? numbered : new ArrayList<CodegenSubstitutionParamEntry>(named.values());
        method.getBlock().declareVar(Integer.TYPE, "zidx", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("index"), "-", CodegenExpressionBuilder.constant(1)));
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength(CodegenExpressionBuilder.ref("zidx"), fields.size(), false);
        for (int i = 0; i < blocks.length; ++i) {
            CodegenSubstitutionParamEntry param = fields.get(i);
            blocks[i].assignRef(CodegenExpressionBuilder.field(param.getField()), CodegenExpressionBuilder.cast(JavaClassHelper.getBoxedType(param.getType()), (CodegenExpression)CodegenExpressionBuilder.ref("value")));
        }
    }
}

