/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.core;

import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import java.util.Map;
import java.util.Set;

public class CodegenTypedParam {
    private final String typeName;
    private final Class type;
    private final String name;
    private final boolean memberWhenCtorParam;
    private final boolean isPublic;
    private boolean isFinal = true;
    private boolean isStatic = false;

    public CodegenTypedParam(String typeName, Class type, String name, boolean memberWhenCtorParam, boolean isPublic) {
        if (type == null && typeName == null) {
            throw new IllegalArgumentException("Invalid null type");
        }
        this.typeName = typeName;
        this.type = type;
        this.name = name;
        this.memberWhenCtorParam = memberWhenCtorParam;
        this.isPublic = isPublic;
    }

    public CodegenTypedParam(String typeName, Class type, String name) {
        this(typeName, type, name, true, false);
    }

    public CodegenTypedParam(Class type, String name) {
        this(null, type, name);
    }

    public CodegenTypedParam(Class type, String name, boolean memberWhenCtorParam) {
        this(null, type, name, memberWhenCtorParam, false);
    }

    public CodegenTypedParam(Class type, String name, boolean memberWhenCtorParam, boolean isPublic) {
        this(null, type, name, memberWhenCtorParam, isPublic);
    }

    public CodegenTypedParam(String typeName, String name, boolean memberWhenCtorParam, boolean isPublic) {
        this(typeName, null, name, memberWhenCtorParam, isPublic);
    }

    public CodegenTypedParam(String type, String name) {
        this(type, null, name);
    }

    public CodegenTypedParam setFinal(boolean aFinal) {
        this.isFinal = aFinal;
        return this;
    }

    public CodegenTypedParam setStatic(boolean aStatic) {
        this.isStatic = aStatic;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void renderAsParameter(StringBuilder builder, Map<Class, String> imports) {
        if (this.type != null) {
            CodeGenerationHelper.appendClassName(builder, this.type, null, imports);
        } else {
            builder.append(this.typeName);
        }
        builder.append(" ").append(this.name);
    }

    public void mergeClasses(Set<Class> classes) {
        if (this.type != null) {
            classes.add(this.type);
        }
    }

    public void renderAsMember(StringBuilder builder, Map<Class, String> imports) {
        if (this.type != null) {
            CodeGenerationHelper.appendClassName(builder, this.type, null, imports);
        } else {
            builder.append(this.typeName);
        }
        builder.append(" ").append(this.name);
    }

    public void renderType(StringBuilder builder, Map<Class, String> imports) {
        if (this.type != null) {
            CodeGenerationHelper.appendClassName(builder, this.type, null, imports);
        } else {
            builder.append(this.typeName);
        }
    }

    public boolean isMemberWhenCtorParam() {
        return this.memberWhenCtorParam;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String toString() {
        return "CodegenTypedParam{typeName='" + this.typeName + '\'' + ", type=" + this.type + ", name='" + this.name + '\'' + ", memberWhenCtorParam=" + this.memberWhenCtorParam + '}';
    }
}

