/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionAndOr
implements CodegenExpression {
    private final boolean isAnd;
    private final CodegenExpression first;
    private final CodegenExpression second;
    private final CodegenExpression[] optionalMore;

    public CodegenExpressionAndOr(boolean isAnd, CodegenExpression first, CodegenExpression second, CodegenExpression[] optionalMore) {
        this.isAnd = isAnd;
        this.first = first;
        this.second = second;
        this.optionalMore = optionalMore;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        builder.append("(");
        this.first.render(builder, imports, isInnerClass);
        builder.append(this.isAnd ? "&&" : "||");
        this.second.render(builder, imports, isInnerClass);
        if (this.optionalMore != null) {
            for (CodegenExpression expr : this.optionalMore) {
                builder.append(this.isAnd ? "&&" : "||");
                expr.render(builder, imports, isInnerClass);
            }
        }
        builder.append(")");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.first.mergeClasses(classes);
        this.second.mergeClasses(classes);
        if (this.optionalMore != null) {
            for (CodegenExpression expr : this.optionalMore) {
                expr.mergeClasses(classes);
            }
        }
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.first);
        consumer.accept(this.second);
        CodegenExpressionBuilder.traverseMultiple(this.optionalMore, consumer);
    }
}

