/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionEnumOrPublicConstantValue
implements CodegenExpression {
    private final Class enumType;
    private final String enumTypeString;
    private final String enumValue;

    public CodegenExpressionEnumOrPublicConstantValue(Class enumType, String enumValue) {
        this.enumType = enumType;
        this.enumTypeString = null;
        this.enumValue = enumValue;
    }

    public CodegenExpressionEnumOrPublicConstantValue(String enumTypeString, String enumValue) {
        this.enumTypeString = enumTypeString;
        this.enumValue = enumValue;
        this.enumType = null;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        if (this.enumType != null) {
            CodeGenerationHelper.appendClassName(builder, this.enumType, null, imports);
        } else {
            builder.append(this.enumTypeString);
        }
        builder.append(".");
        builder.append(this.enumValue);
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        classes.add(this.enumType);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
    }
}

