/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionRelational
implements CodegenExpression {
    private final CodegenExpression lhs;
    private final CodegenRelational op;
    private final CodegenExpression rhs;

    public CodegenExpressionRelational(CodegenExpression lhs, CodegenRelational op, CodegenExpression rhs) {
        this.lhs = lhs;
        this.op = op;
        this.rhs = rhs;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        this.lhs.render(builder, imports, isInnerClass);
        builder.append(this.op.getOp());
        this.rhs.render(builder, imports, isInnerClass);
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.lhs.mergeClasses(classes);
        this.rhs.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.lhs);
        consumer.accept(this.rhs);
    }

    public static enum CodegenRelational {
        GE(">="),
        GT(">"),
        LE("<="),
        LT("<");

        private final String op;

        private CodegenRelational(String op) {
            this.op = op;
        }

        public String getOp() {
            return this.op;
        }
    }
}

