/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionClass;
import com.espertech.esper.common.internal.util.apachecommonstext.StringEscapeUtils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class CodegenExpressionUtil {
    public static void renderConstant(StringBuilder builder, Object constant, Map<Class, String> imports) {
        if (constant instanceof String) {
            builder.append('\"').append(StringEscapeUtils.escapeJava((String)constant)).append('\"');
        } else if (constant instanceof CharSequence) {
            CodegenExpressionUtil.appendSequenceEscapeDQ(builder, (CharSequence)constant);
        } else if (constant instanceof Character) {
            Character c = (Character)constant;
            if (c.charValue() == '\'') {
                builder.append('\'');
                builder.append('\\');
                builder.append('\'');
                builder.append('\'');
            } else if (c.charValue() == '\\') {
                builder.append('\'');
                builder.append('\\');
                builder.append('\\');
                builder.append('\'');
            } else {
                builder.append('\'');
                builder.append(c);
                builder.append('\'');
            }
        } else if (constant == null) {
            builder.append("null");
        } else if (constant instanceof Long) {
            builder.append(constant).append("L");
        } else if (constant instanceof Float) {
            builder.append(constant).append("F");
        } else if (constant instanceof Short) {
            builder.append("(short) ").append(constant);
        } else if (constant instanceof Byte) {
            builder.append("(byte)").append(constant);
        } else if (constant.getClass().isArray()) {
            if (Array.getLength(constant) == 0) {
                builder.append("new ");
                CodeGenerationHelper.appendClassName(builder, constant.getClass().getComponentType(), null, imports);
                builder.append("[]{}");
            } else {
                builder.append("new ");
                CodeGenerationHelper.appendClassName(builder, constant.getClass().getComponentType(), null, imports);
                builder.append("[] {");
                String delimiter = "";
                for (int i = 0; i < Array.getLength(constant); ++i) {
                    builder.append(delimiter);
                    CodegenExpressionUtil.renderConstant(builder, Array.get(constant, i), imports);
                    delimiter = ",";
                }
                builder.append("}");
            }
        } else if (constant.getClass().isEnum()) {
            CodeGenerationHelper.appendClassName(builder, constant.getClass(), null, imports);
            builder.append(".").append(constant);
        } else if (constant instanceof Class) {
            CodegenExpressionClass.renderClass((Class)constant, builder, imports);
        } else if (constant instanceof BigInteger) {
            CodegenExpressionUtil.renderBigInteger((BigInteger)constant, builder, imports);
        } else if (constant instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)constant;
            builder.append("new BigDecimal(");
            CodegenExpressionUtil.renderBigInteger(bigDecimal.unscaledValue(), builder, imports);
            builder.append(",").append(bigDecimal.scale()).append(")");
        } else {
            builder.append(constant);
        }
    }

    private static void renderBigInteger(BigInteger constant, StringBuilder builder, Map<Class, String> imports) {
        builder.append("new java.math.BigInteger(");
        CodegenExpressionUtil.renderConstant(builder, constant.toByteArray(), imports);
        builder.append(")");
    }

    private static void appendSequenceEscapeDQ(StringBuilder builder, CharSequence seq) {
        for (int i = 0; i < seq.length(); ++i) {
            char c = seq.charAt(i);
            if (c == '\"') {
                builder.append('\\');
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
    }
}

