/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementAssignCompound
extends CodegenStatementBase {
    private final CodegenExpression lhs;
    private final String operator;
    private final CodegenExpression assignment;

    public CodegenStatementAssignCompound(CodegenExpression lhs, String operator, CodegenExpression assignment) {
        this.lhs = lhs;
        this.operator = operator;
        this.assignment = assignment;
    }

    @Override
    public void renderStatement(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        this.lhs.render(builder, imports, isInnerClass);
        builder.append(this.operator);
        builder.append("=");
        this.assignment.render(builder, imports, isInnerClass);
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.assignment.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.lhs);
        consumer.accept(this.assignment);
    }
}

