/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.EventUnderlyingIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class EventUnderlyingCollection
implements Collection<Object> {
    private final Collection<EventBean> events;
    private Collection<Object> buf;

    public EventUnderlyingCollection(Collection<EventBean> events) {
        this.events = events;
    }

    private void init() {
        if (this.buf == null) {
            Object[] objects = new Object[this.events.size()];
            int count = 0;
            for (EventBean theEvent : this.events) {
                objects[count++] = theEvent.getUnderlying();
            }
            this.buf = Arrays.asList(objects);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.init();
        return this.buf.containsAll(c);
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        int count = 0;
        for (EventBean theEvent : this.events) {
            arr[count++] = theEvent.getUnderlying();
        }
        return arr;
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.events.size()];
        int count = 0;
        for (EventBean theEvent : this.events) {
            arr[count++] = theEvent.getUnderlying();
        }
        return arr;
    }

    @Override
    public Iterator<Object> iterator() {
        return new EventUnderlyingIterator(this.events);
    }

    @Override
    public boolean contains(Object o) {
        this.init();
        return this.buf.contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public int size() {
        return this.events.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Read-only implementation");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Read-only implementation");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Read-only implementation");
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException("Read-only implementation");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Read-only implementation");
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException("Read-only implementation");
    }
}

