/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.collection.IntSeqKeyFive;
import com.espertech.esper.common.internal.collection.IntSeqKeyThree;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntSeqKeyFour
implements IntSeqKey {
    private final int one;
    private final int two;
    private final int three;
    private final int four;

    public IntSeqKeyFour(int one, int two, int three, int four) {
        this.one = one;
        this.two = two;
        this.three = three;
        this.four = four;
    }

    @Override
    public boolean isParentTo(IntSeqKey other) {
        if (other.length() != 5) {
            return false;
        }
        IntSeqKeyFive o = (IntSeqKeyFive)other;
        return this.one == o.getOne() && this.two == o.getTwo() && this.three == o.getThree() && this.four == o.getFour();
    }

    @Override
    public IntSeqKey addToEnd(int num) {
        return new IntSeqKeyFive(this.one, this.two, this.three, this.four, num);
    }

    @Override
    public IntSeqKey removeFromEnd() {
        return new IntSeqKeyThree(this.one, this.two, this.three);
    }

    @Override
    public int length() {
        return 4;
    }

    @Override
    public int last() {
        return this.four;
    }

    @Override
    public int[] asIntArray() {
        return new int[]{this.one, this.two, this.three, this.four};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntSeqKeyFour that = (IntSeqKeyFour)o;
        if (this.one != that.one) {
            return false;
        }
        if (this.two != that.two) {
            return false;
        }
        if (this.three != that.three) {
            return false;
        }
        return this.four == that.four;
    }

    public int hashCode() {
        int result = this.one;
        result = 31 * result + this.two;
        result = 31 * result + this.three;
        result = 31 * result + this.four;
        return result;
    }

    public int getOne() {
        return this.one;
    }

    public int getTwo() {
        return this.two;
    }

    public int getThree() {
        return this.three;
    }

    public int getFour() {
        return this.four;
    }

    public static void write(IntSeqKeyFour key, DataOutput output) throws IOException {
        output.writeInt(key.one);
        output.writeInt(key.two);
        output.writeInt(key.three);
        output.writeInt(key.four);
    }

    public static IntSeqKeyFour read(DataInput input) throws IOException {
        return new IntSeqKeyFour(input.readInt(), input.readInt(), input.readInt(), input.readInt());
    }
}

