/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathDeploymentEntry;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathExceptionAmbiguous;
import com.espertech.esper.common.internal.collection.PathRegistryObjectType;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class PathModuleEntry<E> {
    private final Map<String, PathDeploymentEntry<E>> modules;

    PathModuleEntry() {
        this.modules = new HashMap<String, PathDeploymentEntry<E>>(CollectionUtil.capacityHashMap(1));
    }

    private PathModuleEntry(Map<String, PathDeploymentEntry<E>> modules) {
        this.modules = modules;
    }

    public void add(String moduleName, E entity, String deploymentId) {
        this.modules.put(moduleName, new PathDeploymentEntry<E>(deploymentId, entity));
    }

    public Pair<E, String> getAnyModuleExpectSingle(String entityName, PathRegistryObjectType objectType, Set<String> moduleNames) throws PathException {
        if (this.modules.isEmpty()) {
            return null;
        }
        if (moduleNames == null || moduleNames.isEmpty()) {
            if (this.modules.size() > 1) {
                throw new PathExceptionAmbiguous(entityName, objectType);
            }
            String moduleName = this.modules.keySet().iterator().next();
            PathDeploymentEntry<E> entry = this.modules.get(moduleName);
            if (entry == null) {
                return null;
            }
            return new Pair<E, String>(entry.getEntity(), moduleName);
        }
        PathDeploymentEntry<E> found = null;
        String moduleNameFound = null;
        for (String moduleName : moduleNames) {
            PathDeploymentEntry<E> entry = this.modules.get(moduleName);
            if (entry == null) continue;
            if (found != null) {
                throw new PathExceptionAmbiguous(entityName, objectType);
            }
            found = entry;
            moduleNameFound = moduleName;
        }
        return found == null ? null : new Pair(found.getEntity(), moduleNameFound);
    }

    public String getDeploymentId(String moduleName) {
        PathDeploymentEntry<E> existing = this.modules.get(moduleName);
        return existing == null ? null : existing.getDeploymentId();
    }

    public E getWithModule(String moduleName) {
        PathDeploymentEntry<E> entry = this.modules.get(moduleName);
        return entry == null ? null : (E)entry.getEntity();
    }

    public boolean deleteDeployment(String deploymentId) {
        for (Map.Entry<String, PathDeploymentEntry<E>> entry : this.modules.entrySet()) {
            if (!entry.getValue().getDeploymentId().equals(deploymentId)) continue;
            this.modules.remove(entry.getKey());
            return this.modules.isEmpty();
        }
        return this.modules.isEmpty();
    }

    public void addDependency(String entityName, String moduleName, String deploymentIdDep, PathRegistryObjectType objectType) {
        PathDeploymentEntry<E> existing = this.modules.get(moduleName);
        if (existing == null) {
            throw new IllegalArgumentException("Failed to find " + objectType.getName() + " '" + entityName + "' under module '" + moduleName + "'");
        }
        existing.addDependency(deploymentIdDep);
    }

    public Set<String> getDependencies(String entityName, String moduleName, PathRegistryObjectType objectType) {
        PathDeploymentEntry<E> existing = this.modules.get(moduleName);
        if (existing == null) {
            throw new IllegalArgumentException("Failed to find " + objectType.getName() + " '" + entityName + "' under module '" + moduleName + "'");
        }
        return existing.getDependencies();
    }

    public void removeDependency(String moduleName, String deploymentId) {
        PathDeploymentEntry<E> existing = this.modules.get(moduleName);
        if (existing == null) {
            return;
        }
        existing.removeDependency(deploymentId);
    }

    public void traverse(Consumer<E> consumer) {
        for (Map.Entry<String, PathDeploymentEntry<E>> entry : this.modules.entrySet()) {
            consumer.accept(entry.getValue().getEntity());
        }
    }

    public PathModuleEntry<E> copy() {
        HashMap<String, PathDeploymentEntry<E>> copy = new HashMap<String, PathDeploymentEntry<E>>(4);
        for (Map.Entry<String, PathDeploymentEntry<E>> entry : this.modules.entrySet()) {
            PathDeploymentEntry<E> copyEntry = entry.getValue().copy();
            copy.put(entry.getKey(), copyEntry);
        }
        return new PathModuleEntry<E>(copy);
    }
}

