/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathExceptionAlreadyRegistered;
import com.espertech.esper.common.internal.collection.PathModuleEntry;
import com.espertech.esper.common.internal.collection.PathRegistryObjectType;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class PathRegistry<K, E> {
    private final PathRegistryObjectType objectType;
    private final Map<K, PathModuleEntry<E>> entities;

    public PathRegistry(PathRegistryObjectType objectType) {
        this.objectType = objectType;
        this.entities = new HashMap<K, PathModuleEntry<E>>();
    }

    private PathRegistry(PathRegistryObjectType objectType, Map<K, PathModuleEntry<E>> entities) {
        this.objectType = objectType;
        this.entities = entities;
    }

    public PathRegistryObjectType getObjectType() {
        return this.objectType;
    }

    public void add(K entityKey, String moduleName, E entity, String deploymentId) throws PathException {
        this.checkModuleNameParameter(moduleName);
        PathModuleEntry<E> existing = this.entities.get(entityKey);
        if (existing == null) {
            existing = new PathModuleEntry();
            this.entities.put(entityKey, existing);
        } else {
            String existingDeploymentId = existing.getDeploymentId(moduleName);
            if (existingDeploymentId != null) {
                throw new PathExceptionAlreadyRegistered(entityKey.toString(), this.objectType, moduleName);
            }
        }
        existing.add(moduleName, entity, deploymentId);
    }

    public Pair<E, String> getAnyModuleExpectSingle(K entityKey, Set<String> moduleUses) throws PathException {
        PathModuleEntry<E> existing = this.entities.get(entityKey);
        return existing == null ? null : existing.getAnyModuleExpectSingle(entityKey.toString(), this.objectType, moduleUses);
    }

    public E getWithModule(K entityKey, String moduleName) {
        this.checkModuleNameParameter(moduleName);
        PathModuleEntry<E> existing = this.entities.get(entityKey);
        return existing == null ? null : (E)existing.getWithModule(moduleName);
    }

    public String getDeploymentId(K entityEntity, String moduleName) {
        this.checkModuleNameParameter(moduleName);
        PathModuleEntry<E> existing = this.entities.get(entityEntity);
        return existing == null ? null : existing.getDeploymentId(moduleName);
    }

    public void deleteDeployment(String deploymentId) {
        Iterator<Map.Entry<K, PathModuleEntry<E>>> it = this.entities.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, PathModuleEntry<E>> entry = it.next();
            boolean empty = entry.getValue().deleteDeployment(deploymentId);
            if (!empty) continue;
            it.remove();
        }
    }

    public int getCount() {
        return this.entities.size();
    }

    public void addDependency(K entityKey, String moduleName, String deploymentIdDep) {
        this.checkModuleNameParameter(moduleName);
        PathModuleEntry<E> existing = this.entities.get(entityKey);
        if (existing == null) {
            throw new IllegalArgumentException("Failed to find " + this.objectType.getName() + " '" + entityKey + "'");
        }
        existing.addDependency(entityKey.toString(), moduleName, deploymentIdDep, this.objectType);
    }

    public Set<String> getDependencies(K entityKey, String moduleName) {
        this.checkModuleNameParameter(moduleName);
        PathModuleEntry<E> existing = this.entities.get(entityKey);
        if (existing == null) {
            return null;
        }
        return existing.getDependencies(entityKey.toString(), moduleName, this.objectType);
    }

    public void removeDependency(K entityKey, String moduleName, String deploymentId) {
        this.checkModuleNameParameter(moduleName);
        PathModuleEntry<E> existing = this.entities.get(entityKey);
        if (existing == null) {
            return;
        }
        existing.removeDependency(moduleName, deploymentId);
    }

    public void traverse(Consumer<E> consumer) {
        for (Map.Entry<K, PathModuleEntry<E>> entry : this.entities.entrySet()) {
            entry.getValue().traverse(consumer);
        }
    }

    private void checkModuleNameParameter(String moduleName) {
        if (moduleName != null && moduleName.length() == 0) {
            throw new IllegalArgumentException("Invalid empty module name, use null or a non-empty value");
        }
    }

    public void mergeFrom(PathRegistry<K, E> other) {
        if (other.objectType != this.objectType) {
            throw new IllegalArgumentException("Invalid object type " + (Object)((Object)other.objectType) + " expected " + (Object)((Object)this.objectType));
        }
        for (Map.Entry<K, PathModuleEntry<E>> entry : other.entities.entrySet()) {
            if (this.entities.containsKey(entry.getKey())) continue;
            this.entities.put(entry.getKey(), entry.getValue());
        }
    }

    public PathRegistry<K, E> copy() {
        HashMap<K, PathModuleEntry<E>> copy = new HashMap<K, PathModuleEntry<E>>(CollectionUtil.capacityHashMap(this.entities.size()));
        for (Map.Entry<K, PathModuleEntry<E>> entry : this.entities.entrySet()) {
            PathModuleEntry<E> entryCopy = entry.getValue().copy();
            copy.put(entry.getKey(), entryCopy);
        }
        return new PathRegistry(this.objectType, copy);
    }
}

