/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RefCountedSet<K> {
    private Map<K, Integer> refSet;
    private int numValues;

    public RefCountedSet() {
        this.refSet = new HashMap<K, Integer>();
    }

    public RefCountedSet(Map<K, Integer> refSet, int numValues) {
        this.refSet = refSet;
        this.numValues = numValues;
    }

    public void clear() {
        this.refSet.clear();
        this.numValues = 0;
    }

    public boolean add(K key) {
        Integer value = this.refSet.get(key);
        if (value == null) {
            this.refSet.put(key, 1);
            ++this.numValues;
            return true;
        }
        Integer n = value;
        Integer n2 = value = Integer.valueOf(value + 1);
        ++this.numValues;
        this.refSet.put(key, value);
        return false;
    }

    public void add(K key, int numReferences) {
        Integer value = this.refSet.get(key);
        if (value == null) {
            this.refSet.put(key, numReferences);
            this.numValues += numReferences;
            return;
        }
        throw new IllegalArgumentException("Key '" + key + "' already in collection");
    }

    public boolean remove(K key) {
        Integer value = this.refSet.get(key);
        if (value == null) {
            return true;
        }
        if (value == 1) {
            this.refSet.remove(key);
            --this.numValues;
            return true;
        }
        Integer n = value;
        Integer n2 = value = Integer.valueOf(value - 1);
        this.refSet.put(key, value);
        --this.numValues;
        return false;
    }

    public boolean removeAll(K key) {
        Integer value = this.refSet.remove(key);
        return value != null;
    }

    public Iterator<Map.Entry<K, Integer>> entryIterator() {
        return this.refSet.entrySet().iterator();
    }

    public Iterator<K> keyIterator() {
        return this.refSet.keySet().iterator();
    }

    public int size() {
        return this.numValues;
    }

    public Map<K, Integer> getRefSet() {
        return this.refSet;
    }

    public int getNumValues() {
        return this.numValues;
    }

    public void setNumValues(int numValues) {
        this.numValues = numValues;
    }
}

