/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

public class RollingTwoValueBuffer<A, B> {
    private final A[] bufferA;
    private final B[] bufferB;
    private int nextFreeIndex;

    public RollingTwoValueBuffer(A[] bufferA, B[] bufferB) {
        if (bufferA.length != bufferB.length || bufferA.length == 0) {
            throw new IllegalArgumentException("Minimum buffer size is 1, buffer sizes must be identical");
        }
        this.bufferA = bufferA;
        this.bufferB = bufferB;
        this.nextFreeIndex = 0;
    }

    public void add(A valueA, B valueB) {
        this.bufferA[this.nextFreeIndex] = valueA;
        this.bufferB[this.nextFreeIndex] = valueB;
        ++this.nextFreeIndex;
        if (this.nextFreeIndex == this.bufferA.length) {
            this.nextFreeIndex = 0;
        }
    }

    public A[] getBufferA() {
        return this.bufferA;
    }

    public B[] getBufferB() {
        return this.bufferB;
    }
}

