/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.TimeWindowIterator;
import com.espertech.esper.common.internal.collection.TimeWindowPair;
import com.espertech.esper.common.internal.view.core.DataWindowViewFactory;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class TimeWindow
implements Iterable {
    private ArrayDeque<TimeWindowPair> window = new ArrayDeque();
    private Map<EventBean, TimeWindowPair> reverseIndex;
    private int size;

    public TimeWindow(boolean isSupportRemoveStream) {
        if (isSupportRemoveStream) {
            this.reverseIndex = new HashMap<EventBean, TimeWindowPair>();
        }
    }

    public void adjust(long delta) {
        for (TimeWindowPair data : this.window) {
            data.setTimestamp(data.getTimestamp() + delta);
        }
    }

    public final void add(long timestamp, EventBean bean) {
        if (this.window.isEmpty()) {
            TimeWindowPair pair = new TimeWindowPair(timestamp, bean);
            this.window.add(pair);
            if (this.reverseIndex != null) {
                this.reverseIndex.put(bean, pair);
            }
            this.size = 1;
            return;
        }
        TimeWindowPair lastPair = this.window.getLast();
        if (lastPair.getTimestamp() == timestamp) {
            if (lastPair.getEventHolder() instanceof List) {
                List list = (List)lastPair.getEventHolder();
                list.add(bean);
            } else if (lastPair.getEventHolder() == null) {
                lastPair.setEventHolder(bean);
            } else {
                EventBean existing = (EventBean)lastPair.getEventHolder();
                ArrayList<EventBean> list = new ArrayList<EventBean>(4);
                list.add(existing);
                list.add(bean);
                lastPair.setEventHolder(list);
            }
            if (this.reverseIndex != null) {
                this.reverseIndex.put(bean, lastPair);
            }
            ++this.size;
            return;
        }
        TimeWindowPair pair = new TimeWindowPair(timestamp, bean);
        if (this.reverseIndex != null) {
            this.reverseIndex.put(bean, pair);
        }
        this.window.add(pair);
        ++this.size;
    }

    public final void remove(EventBean theEvent) {
        if (this.reverseIndex == null) {
            throw new UnsupportedOperationException("Time window does not accept event removal");
        }
        TimeWindowPair pair = this.reverseIndex.get(theEvent);
        if (pair != null) {
            List list;
            boolean removed;
            if (pair.getEventHolder() != null && pair.getEventHolder().equals(theEvent)) {
                pair.setEventHolder(null);
                --this.size;
            } else if (pair.getEventHolder() != null && (removed = (list = (List)pair.getEventHolder()).remove(theEvent))) {
                --this.size;
            }
            this.reverseIndex.remove(theEvent);
        }
    }

    public final ArrayDeque<EventBean> expireEvents(long expireBefore) {
        if (this.window.isEmpty()) {
            return null;
        }
        TimeWindowPair pair = this.window.getFirst();
        if (pair.getTimestamp() >= expireBefore) {
            return null;
        }
        ArrayDeque<EventBean> resultBeans = new ArrayDeque<EventBean>();
        do {
            if (pair.getEventHolder() != null) {
                if (pair.getEventHolder() instanceof EventBean) {
                    resultBeans.add((EventBean)pair.getEventHolder());
                } else {
                    resultBeans.addAll((List)pair.getEventHolder());
                }
            }
            this.window.removeFirst();
        } while (!this.window.isEmpty() && (pair = this.window.getFirst()).getTimestamp() < expireBefore);
        if (this.reverseIndex != null) {
            for (EventBean expired : resultBeans) {
                this.reverseIndex.remove(expired);
            }
        }
        this.size -= resultBeans.size();
        return resultBeans;
    }

    public final Iterator<EventBean> iterator() {
        return new TimeWindowIterator(this.window);
    }

    public final Long getOldestTimestamp() {
        if (this.window.isEmpty()) {
            return null;
        }
        if (this.window.getFirst().getEventHolder() != null) {
            return this.window.getFirst().getTimestamp();
        }
        for (TimeWindowPair pair : this.window) {
            if (pair.getEventHolder() == null) continue;
            return pair.getTimestamp();
        }
        return null;
    }

    public final boolean isEmpty() {
        return this.getOldestTimestamp() == null;
    }

    public Map<EventBean, TimeWindowPair> getReverseIndex() {
        return this.reverseIndex;
    }

    public ArrayDeque<TimeWindowPair> getWindow() {
        return this.window;
    }

    public void setWindow(ArrayDeque<TimeWindowPair> window, int size) {
        this.window = window;
        this.size = size;
    }

    public void setReverseIndex(Map<EventBean, TimeWindowPair> reverseIndex) {
        this.reverseIndex = reverseIndex;
    }

    public void visitView(ViewDataVisitor viewDataVisitor, DataWindowViewFactory viewFactory) {
        viewDataVisitor.visitPrimary(this.window, false, viewFactory.getViewName(), this.size);
    }
}

