/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.multikey;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.util.HashableMultiKey;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import java.util.Arrays;

public class MultiKeyClassRefUUIDBased
implements MultiKeyClassRef {
    private final String uuid = CodeGenerationIDGenerator.generateClassNameUUID();
    private final Class[] mkTypes;
    private String classPostfix;

    public MultiKeyClassRefUUIDBased(Class[] mkTypes) {
        this.mkTypes = mkTypes;
    }

    public String getClassNameMK(String classPostfix) {
        this.assignPostfix(classPostfix);
        return CodeGenerationIDGenerator.generateClassNameWithUUID(HashableMultiKey.class, classPostfix, this.uuid);
    }

    @Override
    public String getClassNameMK() {
        this.checkClassPostfix();
        return this.getClassNameMK(this.classPostfix);
    }

    public String getClassNameMKSerde(String classPostfix) {
        return CodeGenerationIDGenerator.generateClassNameWithUUID(DataInputOutputSerde.class, classPostfix, this.uuid);
    }

    @Override
    public CodegenExpression getExprMKSerde(CodegenMethod method, CodegenClassScope classScope) {
        this.checkClassPostfix();
        return CodegenExpressionBuilder.newInstance(this.getClassNameMKSerde(this.classPostfix), new CodegenExpression[0]);
    }

    @Override
    public Class[] getMKTypes() {
        return this.mkTypes;
    }

    public String toString() {
        return "MultiKeyClassRefUUIDBased{uuid='" + this.uuid + '\'' + ", mkTypes=" + Arrays.toString(this.mkTypes) + ", classPostfix='" + this.classPostfix + '\'' + '}';
    }

    private void checkClassPostfix() {
        if (this.classPostfix == null) {
            throw new IllegalArgumentException("Class postfix has not been assigned");
        }
    }

    private void assignPostfix(String classPostfix) {
        if (this.classPostfix == null) {
            this.classPostfix = classPostfix;
            return;
        }
        if (!this.classPostfix.equals(classPostfix)) {
            throw new IllegalArgumentException("Invalid class postfix");
        }
    }
}

