/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage1.spec;

import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprAndNodeImpl;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNodeImpl;
import com.espertech.esper.common.internal.type.OuterJoinType;
import java.io.Serializable;
import java.util.Collection;

public class OuterJoinDesc
implements Serializable {
    public static final OuterJoinDesc[] EMPTY_OUTERJOIN_ARRAY = new OuterJoinDesc[0];
    private OuterJoinType outerJoinType;
    private ExprIdentNode optLeftNode;
    private ExprIdentNode optRightNode;
    private ExprIdentNode[] optAddLeftNode;
    private ExprIdentNode[] optAddRightNode;
    private static final long serialVersionUID = -2616847070429124382L;

    public OuterJoinDesc(OuterJoinType outerJoinType, ExprIdentNode optLeftNode, ExprIdentNode optRightNode, ExprIdentNode[] optAddLeftNode, ExprIdentNode[] optAddRightNode) {
        this.outerJoinType = outerJoinType;
        this.optLeftNode = optLeftNode;
        this.optRightNode = optRightNode;
        this.optAddLeftNode = optAddLeftNode;
        this.optAddRightNode = optAddRightNode;
    }

    public OuterJoinType getOuterJoinType() {
        return this.outerJoinType;
    }

    public ExprIdentNode getOptLeftNode() {
        return this.optLeftNode;
    }

    public ExprIdentNode getOptRightNode() {
        return this.optRightNode;
    }

    public ExprIdentNode[] getAdditionalLeftNodes() {
        return this.optAddLeftNode;
    }

    public ExprIdentNode[] getAdditionalRightNodes() {
        return this.optAddRightNode;
    }

    public ExprNode makeExprNode(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) {
        ExprNodeBase representativeNode = new ExprEqualsNodeImpl(false, false);
        representativeNode.addChildNode(this.optLeftNode);
        representativeNode.addChildNode(this.optRightNode);
        if (this.optAddLeftNode == null) {
            this.topValidate(representativeNode, statementRawInfo, compileTimeServices);
            return representativeNode;
        }
        ExprAndNodeImpl andNode = new ExprAndNodeImpl();
        this.topValidate(representativeNode, statementRawInfo, compileTimeServices);
        andNode.addChildNode(representativeNode);
        representativeNode = andNode;
        for (int i = 0; i < this.optAddLeftNode.length; ++i) {
            ExprEqualsNodeImpl eqNode = new ExprEqualsNodeImpl(false, false);
            eqNode.addChildNode(this.optAddLeftNode[i]);
            eqNode.addChildNode(this.optAddRightNode[i]);
            this.topValidate(eqNode, statementRawInfo, compileTimeServices);
            andNode.addChildNode(eqNode);
        }
        this.topValidate(andNode, statementRawInfo, compileTimeServices);
        return representativeNode;
    }

    public static boolean consistsOfAllInnerJoins(OuterJoinDesc[] outerJoinDescList) {
        for (OuterJoinDesc desc : outerJoinDescList) {
            if (desc.getOuterJoinType() == OuterJoinType.INNER) continue;
            return false;
        }
        return true;
    }

    public static OuterJoinDesc[] toArray(Collection<OuterJoinDesc> expressions) {
        if (expressions.isEmpty()) {
            return EMPTY_OUTERJOIN_ARRAY;
        }
        return expressions.toArray(new OuterJoinDesc[expressions.size()]);
    }

    private void topValidate(ExprNode exprNode, StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) {
        try {
            ExprValidationContext validationContext = new ExprValidationContextBuilder(null, statementRawInfo, compileTimeServices).build();
            exprNode.validate(validationContext);
        }
        catch (ExprValidationException e) {
            throw new IllegalStateException("Failed to make representative node for outer join criteria");
        }
    }

    public static boolean hasOnClauses(OuterJoinDesc[] outerJoinDescList) {
        for (OuterJoinDesc desc : outerJoinDescList) {
            if (desc.getOptLeftNode() == null) continue;
            return true;
        }
        return false;
    }
}

