/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecParamComparator;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.contained.PropertyEvaluatorForge;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamExprNodeForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;

public final class FilterSpecCompiled {
    private static final FilterSpecParamComparator COMPARATOR_PARAMETERS = new FilterSpecParamComparator();
    private final EventType filterForEventType;
    private final String filterForEventTypeName;
    private final FilterSpecParamForge[][] parameters;
    private final PropertyEvaluatorForge optionalPropertyEvaluator;
    private int filterCallbackId = -1;

    public FilterSpecCompiled(EventType eventType, String eventTypeName, List<FilterSpecParamForge>[] filterParameters, PropertyEvaluatorForge optionalPropertyEvaluator) {
        this.filterForEventType = eventType;
        this.filterForEventTypeName = eventTypeName;
        this.parameters = FilterSpecCompiled.sortRemoveDups(filterParameters);
        this.optionalPropertyEvaluator = optionalPropertyEvaluator;
    }

    public void setFilterCallbackId(int filterCallbackId) {
        this.filterCallbackId = filterCallbackId;
    }

    public final EventType getFilterForEventType() {
        return this.filterForEventType;
    }

    public final FilterSpecParamForge[][] getParameters() {
        return this.parameters;
    }

    public String getFilterForEventTypeName() {
        return this.filterForEventTypeName;
    }

    public PropertyEvaluatorForge getOptionalPropertyEvaluator() {
        return this.optionalPropertyEvaluator;
    }

    public EventType getResultEventType() {
        if (this.optionalPropertyEvaluator != null) {
            return this.optionalPropertyEvaluator.getFragmentEventType();
        }
        return this.filterForEventType;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FilterSpecCompiled type=" + this.filterForEventType);
        buffer.append(" parameters=" + Arrays.toString((Object[])this.parameters));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecCompiled)) {
            return false;
        }
        FilterSpecCompiled other = (FilterSpecCompiled)obj;
        if (!this.equalsTypeAndFilter(other)) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator == null) {
            return true;
        }
        if (this.optionalPropertyEvaluator != null && other.optionalPropertyEvaluator == null) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator != null) {
            return false;
        }
        return this.optionalPropertyEvaluator.compareTo(other.optionalPropertyEvaluator);
    }

    public boolean equalsTypeAndFilter(FilterSpecCompiled other) {
        if (this.filterForEventType != other.filterForEventType) {
            return false;
        }
        if (this.parameters.length != other.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            FilterSpecParamForge[] lineThis = this.parameters[i];
            FilterSpecParamForge[] lineOther = other.parameters[i];
            if (lineThis.length != lineOther.length) {
                return false;
            }
            for (int j = 0; j < lineThis.length; ++j) {
                if (lineThis[j].equals(lineOther[j])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.filterForEventType.hashCode();
        FilterSpecParamForge[][] filterSpecParamForgeArray = this.parameters;
        int n = filterSpecParamForgeArray.length;
        for (int i = 0; i < n; ++i) {
            FilterSpecParamForge[] paramLine;
            for (FilterSpecParamForge param : paramLine = filterSpecParamForgeArray[i]) {
                hashCode ^= 31 * param.hashCode();
            }
        }
        return hashCode;
    }

    protected static FilterSpecParamForge[][] sortRemoveDups(List<FilterSpecParamForge>[] parameters) {
        FilterSpecParamForge[][] processed = new FilterSpecParamForge[parameters.length][];
        for (int i = 0; i < parameters.length; ++i) {
            processed[i] = FilterSpecCompiled.sortRemoveDups(parameters[i]);
        }
        return processed;
    }

    protected static FilterSpecParamForge[] sortRemoveDups(List<FilterSpecParamForge> parameters) {
        if (parameters.isEmpty()) {
            return FilterSpecParamForge.EMPTY_PARAM_ARRAY;
        }
        if (parameters.size() == 1) {
            return new FilterSpecParamForge[]{parameters.get(0)};
        }
        ArrayDeque<FilterSpecParamForge> result = new ArrayDeque<FilterSpecParamForge>();
        TreeMap map = new TreeMap(COMPARATOR_PARAMETERS);
        for (FilterSpecParamForge filterSpecParamForge : parameters) {
            ArrayList<FilterSpecParamForge> list = (ArrayList<FilterSpecParamForge>)map.get((Object)filterSpecParamForge.getFilterOperator());
            if (list == null) {
                list = new ArrayList<FilterSpecParamForge>();
                map.put(filterSpecParamForge.getFilterOperator(), list);
            }
            boolean hasDuplicate = false;
            for (FilterSpecParamForge existing : list) {
                if (!existing.getLookupable().equals(filterSpecParamForge.getLookupable())) continue;
                hasDuplicate = true;
                break;
            }
            if (hasDuplicate) continue;
            list.add(filterSpecParamForge);
        }
        for (Map.Entry entry : map.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        return FilterSpecParamForge.toArray(result);
    }

    public CodegenMethod makeCodegen(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(FilterSpecActivatable.class, FilterSpecCompiled.class, (CodegenScope)classScope);
        if (this.filterCallbackId == -1) {
            throw new IllegalStateException("Unassigned filter callback id");
        }
        CodegenExpression propertyEval = this.optionalPropertyEvaluator == null ? CodegenExpressionBuilder.constantNull() : this.optionalPropertyEvaluator.make(method, symbols, classScope);
        method.getBlock().declareVar(EventType.class, "eventType", EventTypeUtility.resolveTypeCodegen(this.filterForEventType, EPStatementInitServices.REF)).declareVar(FilterSpecParam[][].class, "params", (CodegenExpression)CodegenExpressionBuilder.localMethod(FilterSpecParamForge.makeParamArrayArrayCodegen(this.parameters, classScope, method), CodegenExpressionBuilder.ref("eventType"), symbols.getAddInitSvc(method))).declareVar(FilterSpecActivatable.class, "activatable", CodegenExpressionBuilder.newInstance(FilterSpecActivatable.class, SAIFFInitializeSymbolWEventType.REF_EVENTTYPE, CodegenExpressionBuilder.constant(this.filterForEventType.getName()), CodegenExpressionBuilder.ref("params"), propertyEval, CodegenExpressionBuilder.constant(this.filterCallbackId))).expression(CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getFilterSpecActivatableRegistry", new CodegenExpression[0]).add("register", CodegenExpressionBuilder.ref("activatable"))).methodReturn(CodegenExpressionBuilder.ref("activatable"));
        return method;
    }

    public static List<FilterSpecParamExprNodeForge> makeExprNodeList(List<FilterSpecCompiled> filterSpecCompileds, List<FilterSpecParamExprNodeForge> additionalBooleanExpressions) {
        LinkedHashSet<FilterSpecParamExprNodeForge> boolExprs = new LinkedHashSet<FilterSpecParamExprNodeForge>();
        for (FilterSpecCompiled spec : filterSpecCompileds) {
            spec.traverseFilterBooleanExpr(boolExprs::add);
        }
        boolExprs.addAll(additionalBooleanExpressions);
        return new ArrayList<FilterSpecParamExprNodeForge>(boolExprs);
    }

    public void traverseFilterBooleanExpr(Consumer<FilterSpecParamExprNodeForge> consumer) {
        FilterSpecParamForge[][] filterSpecParamForgeArray = this.parameters;
        int n = filterSpecParamForgeArray.length;
        for (int i = 0; i < n; ++i) {
            FilterSpecParamForge[] params;
            for (FilterSpecParamForge param : params = filterSpecParamForgeArray[i]) {
                if (!(param instanceof FilterSpecParamExprNodeForge)) continue;
                consumer.accept((FilterSpecParamExprNodeForge)param);
            }
        }
    }
}

