/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecParaForgeMap;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.filterspec.FilterForEvalConstantAnyTypeForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalEventPropForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalEventPropIndexedForge;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamConstantForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamEventPropForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamEventPropIndexedForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInValueForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class FilterSpecCompilerConsolidateUtil {
    protected static void consolidate(FilterSpecParaForgeMap filterParamExprMap, String statementName) {
        boolean haveConsolidated;
        HashMap<Pair<ExprFilterSpecLookupableForge, FilterOperator>, ArrayList<FilterSpecParamForge>> mapOfParams = new HashMap<Pair<ExprFilterSpecLookupableForge, FilterOperator>, ArrayList<FilterSpecParamForge>>();
        do {
            haveConsolidated = false;
            mapOfParams.clear();
            for (FilterSpecParamForge currentParam : filterParamExprMap.getFilterParams()) {
                FilterOperator op;
                ExprFilterSpecLookupableForge lookupable = currentParam.getLookupable();
                Pair<ExprFilterSpecLookupableForge, FilterOperator> key = new Pair<ExprFilterSpecLookupableForge, FilterOperator>(lookupable, op = currentParam.getFilterOperator());
                ArrayList<FilterSpecParamForge> existingParam = (ArrayList<FilterSpecParamForge>)mapOfParams.get(key);
                if (existingParam == null) {
                    existingParam = new ArrayList<FilterSpecParamForge>();
                    mapOfParams.put(key, existingParam);
                }
                existingParam.add(currentParam);
            }
            for (List entry : mapOfParams.values()) {
                if (entry.size() <= 1) continue;
                haveConsolidated = true;
                FilterSpecCompilerConsolidateUtil.consolidate(entry, filterParamExprMap, statementName);
            }
        } while (haveConsolidated);
    }

    private static void consolidate(List<FilterSpecParamForge> items, FilterSpecParaForgeMap filterParamExprMap, String statementName) {
        FilterOperator op = items.get(0).getFilterOperator();
        if (op == FilterOperator.NOT_EQUAL) {
            FilterSpecCompilerConsolidateUtil.handleConsolidateNotEqual(items, filterParamExprMap, statementName);
        } else {
            for (int i = 1; i < items.size(); ++i) {
                filterParamExprMap.removeValue(items.get(i));
            }
        }
    }

    private static void handleConsolidateNotEqual(List<FilterSpecParamForge> parameters, FilterSpecParaForgeMap filterParamExprMap, String statementName) {
        ArrayList<FilterSpecParamInValueForge> values = new ArrayList<FilterSpecParamInValueForge>();
        ExprNode lastNotEqualsExprNode = null;
        for (FilterSpecParamForge param : parameters) {
            FilterSpecParamForge eventProp;
            if (param instanceof FilterSpecParamConstantForge) {
                FilterSpecParamConstantForge constantParam = (FilterSpecParamConstantForge)param;
                Object constant = constantParam.getFilterConstant();
                values.add(new FilterForEvalConstantAnyTypeForge(constant));
            } else if (param instanceof FilterSpecParamEventPropForge) {
                eventProp = (FilterSpecParamEventPropForge)param;
                values.add(new FilterForEvalEventPropForge(((FilterSpecParamEventPropForge)eventProp).getResultEventAsName(), ((FilterSpecParamEventPropForge)eventProp).getResultEventProperty(), ((FilterSpecParamEventPropForge)eventProp).getExprIdentNodeEvaluator(), ((FilterSpecParamEventPropForge)eventProp).isMustCoerce(), JavaClassHelper.getBoxedType(((FilterSpecParamEventPropForge)eventProp).getCoercionType())));
            } else if (param instanceof FilterSpecParamEventPropIndexedForge) {
                eventProp = (FilterSpecParamEventPropIndexedForge)param;
                values.add(new FilterForEvalEventPropIndexedForge(((FilterSpecParamEventPropIndexedForge)eventProp).getResultEventAsName(), ((FilterSpecParamEventPropIndexedForge)eventProp).getResultEventIndex(), ((FilterSpecParamEventPropIndexedForge)eventProp).getResultEventProperty(), ((FilterSpecParamEventPropIndexedForge)eventProp).getEventType(), ((FilterSpecParamEventPropIndexedForge)eventProp).isMustCoerce(), JavaClassHelper.getBoxedType(((FilterSpecParamEventPropIndexedForge)eventProp).getCoercionType())));
            } else {
                throw new IllegalArgumentException("Unknown filter parameter:" + param.toString());
            }
            lastNotEqualsExprNode = filterParamExprMap.removeEntry(param);
        }
        FilterSpecParamInForge param = new FilterSpecParamInForge(parameters.get(0).getLookupable(), FilterOperator.NOT_IN_LIST_OF_VALUES, values);
        filterParamExprMap.put(lastNotEqualsExprNode, param);
    }
}

