/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.annotation.Hint;
import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.internal.collection.CombinationEnumeration;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerArgs;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerConsolidateUtil;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerMakeParamUtil;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecParaForgeMap;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprAndNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprOrNode;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeTableAccessFinderVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVariableVisitor;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamExprNodeForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class FilterSpecCompilerPlanner {
    public static final String PROPERTY_NAME_BOOLEAN_EXPRESSION = ".boolean_expression";

    public static List<FilterSpecParamForge>[] planFilterParameters(List<ExprNode> validatedNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        if (validatedNodes.isEmpty()) {
            return FilterSpecCompilerPlanner.allocateListArray(0);
        }
        FilterSpecParaForgeMap filterParamExprMap = new FilterSpecParaForgeMap();
        FilterSpecCompilerPlanner.decomposePopulateConsolidate(filterParamExprMap, validatedNodes, args);
        ArrayList<FilterSpecParamForge> filterParams = new ArrayList<FilterSpecParamForge>();
        filterParams.addAll(filterParamExprMap.getFilterParams());
        int countUnassigned = filterParamExprMap.countUnassignedExpressions();
        if (countUnassigned == 0) {
            return FilterSpecCompilerPlanner.allocateListArraySizeOne(filterParams);
        }
        int filterServiceMaxFilterWidth = args.compileTimeServices.getConfiguration().getCompiler().getExecution().getFilterServiceMaxFilterWidth();
        Hint hint = HintEnum.MAX_FILTER_WIDTH.getHint(args.statementRawInfo.getAnnotations());
        if (hint != null) {
            String hintValue = HintEnum.MAX_FILTER_WIDTH.getHintAssignedValue(hint);
            filterServiceMaxFilterWidth = Integer.parseInt(hintValue);
        }
        List<FilterSpecParamForge>[] plan = null;
        if (filterServiceMaxFilterWidth > 0) {
            plan = FilterSpecCompilerPlanner.planRemainingNodesIfFeasible(filterParamExprMap, args, filterServiceMaxFilterWidth);
        }
        if (plan != null) {
            return plan;
        }
        FilterSpecParamForge node = FilterSpecCompilerPlanner.makeRemainingNode(filterParamExprMap.getUnassignedExpressions(), args);
        filterParams.add(node);
        return FilterSpecCompilerPlanner.allocateListArraySizeOne(filterParams);
    }

    private static List<FilterSpecParamForge>[] planRemainingNodesIfFeasible(FilterSpecParaForgeMap overallExpressions, FilterSpecCompilerArgs args, int filterServiceMaxFilterWidth) throws ExprValidationException {
        List<ExprNode> unassigned = overallExpressions.getUnassignedExpressions();
        ArrayList<ExprOrNode> orNodes = new ArrayList<ExprOrNode>(unassigned.size());
        for (ExprNode node : unassigned) {
            if (!(node instanceof ExprOrNode)) continue;
            orNodes.add((ExprOrNode)node);
        }
        FilterSpecParaForgeMap expressionsWithoutOr = new FilterSpecParaForgeMap();
        expressionsWithoutOr.add(overallExpressions);
        FilterSpecParaForgeMap[][] orNodesMaps = new FilterSpecParaForgeMap[orNodes.size()][];
        int countOr = 0;
        int sizeFactorized = 1;
        int[] sizePerOr = new int[orNodes.size()];
        for (ExprOrNode orNode : orNodes) {
            expressionsWithoutOr.removeNode(orNode);
            orNodesMaps[countOr] = new FilterSpecParaForgeMap[orNode.getChildNodes().length];
            int len = orNode.getChildNodes().length;
            for (int i = 0; i < len; ++i) {
                FilterSpecParaForgeMap map;
                orNodesMaps[countOr][i] = map = new FilterSpecParaForgeMap();
                List<ExprNode> nodes = Collections.singletonList(orNode.getChildNodes()[i]);
                FilterSpecCompilerPlanner.decomposePopulateConsolidate(map, nodes, args);
            }
            sizePerOr[countOr] = len;
            sizeFactorized *= len;
            ++countOr;
        }
        if (sizeFactorized > filterServiceMaxFilterWidth) {
            return null;
        }
        List[] result = new List[sizeFactorized];
        CombinationEnumeration permutations = CombinationEnumeration.fromZeroBasedRanges(sizePerOr);
        int count = 0;
        while (permutations.hasMoreElements()) {
            Object[] permutation = permutations.nextElement();
            result[count] = FilterSpecCompilerPlanner.computePermutation(expressionsWithoutOr, permutation, orNodesMaps, args);
            ++count;
        }
        return result;
    }

    private static List<FilterSpecParamForge> computePermutation(FilterSpecParaForgeMap filterParamExprMap, Object[] permutation, FilterSpecParaForgeMap[][] orNodesMaps, FilterSpecCompilerArgs args) throws ExprValidationException {
        FilterSpecParaForgeMap mapAll = new FilterSpecParaForgeMap();
        mapAll.add(filterParamExprMap);
        for (int orNodeNum = 0; orNodeNum < permutation.length; ++orNodeNum) {
            int orChildNodeNum = (Integer)permutation[orNodeNum];
            FilterSpecParaForgeMap mapOrSub = orNodesMaps[orNodeNum][orChildNodeNum];
            mapAll.add(mapOrSub);
        }
        FilterSpecCompilerConsolidateUtil.consolidate(mapAll, args.statementRawInfo.getStatementName());
        ArrayList<FilterSpecParamForge> filterParams = new ArrayList<FilterSpecParamForge>();
        filterParams.addAll(mapAll.getFilterParams());
        int countUnassigned = mapAll.countUnassignedExpressions();
        if (countUnassigned == 0) {
            return filterParams;
        }
        FilterSpecParamForge node = FilterSpecCompilerPlanner.makeRemainingNode(mapAll.getUnassignedExpressions(), args);
        filterParams.add(node);
        return filterParams;
    }

    private static void decomposePopulateConsolidate(FilterSpecParaForgeMap filterParamExprMap, List<ExprNode> validatedNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        List<ExprNode> constituents = FilterSpecCompilerPlanner.decomposeCheckAggregation(validatedNodes);
        for (ExprNode constituent : constituents) {
            FilterSpecParamForge param = FilterSpecCompilerMakeParamUtil.makeFilterParam(constituent, args.arrayEventTypes, args.statementRawInfo.getStatementName());
            filterParamExprMap.put(constituent, param);
        }
        FilterSpecCompilerConsolidateUtil.consolidate(filterParamExprMap, args.statementRawInfo.getStatementName());
    }

    private static FilterSpecParamForge makeRemainingNode(List<ExprNode> unassignedExpressions, FilterSpecCompilerArgs args) throws ExprValidationException {
        if (unassignedExpressions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ExprNode exprNode = unassignedExpressions.size() == 1 ? unassignedExpressions.get(0) : FilterSpecCompilerPlanner.makeValidateAndNode(unassignedExpressions, args);
        return FilterSpecCompilerPlanner.makeBooleanExprParam(exprNode, args);
    }

    private static List<FilterSpecParamForge>[] allocateListArraySizeOne(List<FilterSpecParamForge> params) {
        List<FilterSpecParamForge>[] arr = FilterSpecCompilerPlanner.allocateListArray(1);
        arr[0] = params;
        return arr;
    }

    private static List<FilterSpecParamForge>[] allocateListArray(int i) {
        return new List[i];
    }

    private static FilterSpecParamForge makeBooleanExprParam(ExprNode exprNode, FilterSpecCompilerArgs args) {
        boolean hasSubselectFilterStream = FilterSpecCompilerPlanner.determineSubselectFilterStream(exprNode);
        boolean hasTableAccess = FilterSpecCompilerPlanner.determineTableAccessFilterStream(exprNode);
        ExprNodeVariableVisitor visitor = new ExprNodeVariableVisitor(args.compileTimeServices.getVariableCompileTimeResolver());
        exprNode.accept(visitor);
        boolean hasVariable = visitor.isHasVariables();
        Class evalType = exprNode.getForge().getEvaluationType();
        DataInputOutputSerdeForge serdeForge = args.compileTimeServices.getSerdeResolver().serdeForFilter(evalType, args.statementRawInfo);
        ExprFilterSpecLookupableForge lookupable = new ExprFilterSpecLookupableForge(PROPERTY_NAME_BOOLEAN_EXPRESSION, null, evalType, false, serdeForge);
        return new FilterSpecParamExprNodeForge(lookupable, FilterOperator.BOOLEAN_EXPRESSION, exprNode, args.taggedEventTypes, args.arrayEventTypes, args.streamTypeService, hasSubselectFilterStream, hasTableAccess, hasVariable, args.compileTimeServices);
    }

    private static ExprAndNode makeValidateAndNode(List<ExprNode> remainingExprNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        ExprAndNode andNode = ExprNodeUtilityMake.connectExpressionsByLogicalAnd(remainingExprNodes);
        ExprValidationContext validationContext = new ExprValidationContextBuilder(args.streamTypeService, args.statementRawInfo, args.compileTimeServices).withAllowBindingConsumption(true).withContextDescriptor(args.contextDescriptor).build();
        andNode.validate(validationContext);
        return andNode;
    }

    private static boolean determineTableAccessFilterStream(ExprNode exprNode) {
        ExprNodeTableAccessFinderVisitor visitor = new ExprNodeTableAccessFinderVisitor();
        exprNode.accept(visitor);
        return visitor.isHasTableAccess();
    }

    private static boolean determineSubselectFilterStream(ExprNode exprNode) {
        ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
        exprNode.accept(visitor);
        if (visitor.getSubselects().isEmpty()) {
            return false;
        }
        for (ExprSubselectNode subselectNode : visitor.getSubselects()) {
            if (!subselectNode.isFilterStreamSubselect()) continue;
            return true;
        }
        return false;
    }

    private static List<ExprNode> decomposeCheckAggregation(List<ExprNode> validatedNodes) throws ExprValidationException {
        ArrayList<ExprNode> constituents = new ArrayList<ExprNode>();
        for (ExprNode validated : validatedNodes) {
            if (validated instanceof ExprAndNode) {
                FilterSpecCompilerPlanner.recursiveAndConstituents(constituents, validated);
            } else {
                constituents.add(validated);
            }
            LinkedList<ExprAggregateNode> aggregateExprNodes = new LinkedList<ExprAggregateNode>();
            ExprAggregateNodeUtil.getAggregatesBottomUp(validated, aggregateExprNodes);
            if (aggregateExprNodes.isEmpty()) continue;
            throw new ExprValidationException("Aggregation functions not allowed within filters");
        }
        return constituents;
    }

    private static void recursiveAndConstituents(List<ExprNode> constituents, ExprNode exprNode) {
        for (ExprNode inner : exprNode.getChildNodes()) {
            if (inner instanceof ExprAndNode) {
                FilterSpecCompilerPlanner.recursiveAndConstituents(constituents, inner);
                continue;
            }
            constituents.add(inner);
        }
    }
}

