/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FilterSpecParaForgeMap {
    private Map<ExprNode, FilterSpecParamForge> exprNodes = new LinkedHashMap<ExprNode, FilterSpecParamForge>();
    private Map<FilterSpecParamForge, ExprNode> specParams = new LinkedHashMap<FilterSpecParamForge, ExprNode>();

    public void put(ExprNode exprNode, FilterSpecParamForge param) {
        this.exprNodes.put(exprNode, param);
        if (param != null) {
            this.specParams.put(param, exprNode);
        }
    }

    public List<ExprNode> getUnassignedExpressions() {
        ArrayList<ExprNode> unassigned = new ArrayList<ExprNode>();
        for (Map.Entry<ExprNode, FilterSpecParamForge> entry : this.exprNodes.entrySet()) {
            if (entry.getValue() != null) continue;
            unassigned.add(entry.getKey());
        }
        return unassigned;
    }

    public int countUnassignedExpressions() {
        int count = 0;
        for (Map.Entry<ExprNode, FilterSpecParamForge> entry : this.exprNodes.entrySet()) {
            if (entry.getValue() != null) continue;
            ++count;
        }
        return count;
    }

    public Collection<FilterSpecParamForge> getFilterParams() {
        return this.specParams.keySet();
    }

    public void removeNode(ExprNode node) {
        FilterSpecParamForge param = this.exprNodes.remove(node);
        if (param != null) {
            this.specParams.remove(param);
        }
    }

    public ExprNode removeEntry(FilterSpecParamForge param) {
        ExprNode exprNode = this.specParams.get(param);
        if (exprNode == null) {
            throw new IllegalStateException("Not found in collection param: " + param);
        }
        this.specParams.remove(param);
        this.exprNodes.remove(exprNode);
        return exprNode;
    }

    public void removeValue(FilterSpecParamForge param) {
        ExprNode exprNode = this.specParams.get(param);
        if (exprNode == null) {
            throw new IllegalStateException("Not found in collection param: " + param);
        }
        this.specParams.remove(param);
        this.exprNodes.put(exprNode, null);
    }

    public void clear() {
        this.exprNodes.clear();
        this.specParams.clear();
    }

    public void add(FilterSpecParaForgeMap other) {
        this.exprNodes.putAll(other.exprNodes);
        this.specParams.putAll(other.specParams);
    }
}

