/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.compile.stage1.spec.FilterStreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpecDelete;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpecInsert;
import com.espertech.esper.common.internal.compile.stage1.spec.FireAndForgetSpecUpdate;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeAction;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionInsert;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeMatched;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSplitStream;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerType;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerWindowDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementWildcard;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseExprRawSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamRawSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.StatementSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecRaw;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseElementCompiled;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseExprCompiledSpec;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseSpecCompiled;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectClauseStreamCompiledSpec;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeResolver;
import java.util.ArrayList;
import java.util.List;

public class StatementLifecycleSvcUtil {
    public static boolean determineHasTableAccess(List<ExprSubselectNode> subselectNodes, StatementSpecRaw statementSpecRaw, TableCompileTimeResolver tableCompileTimeResolver) {
        boolean hasTableAccess = statementSpecRaw.getTableExpressions() != null && !statementSpecRaw.getTableExpressions().isEmpty() || statementSpecRaw.getIntoTableSpec() != null;
        hasTableAccess = hasTableAccess || StatementLifecycleSvcUtil.isJoinWithTable(statementSpecRaw, tableCompileTimeResolver) || StatementLifecycleSvcUtil.isSubqueryWithTable(subselectNodes, tableCompileTimeResolver) || StatementLifecycleSvcUtil.isInsertIntoTable(statementSpecRaw, tableCompileTimeResolver);
        return hasTableAccess;
    }

    private static boolean isInsertIntoTable(StatementSpecRaw statementSpecRaw, TableCompileTimeResolver tableCompileTimeResolver) {
        if (statementSpecRaw.getInsertIntoDesc() == null) {
            return false;
        }
        return tableCompileTimeResolver.resolve(statementSpecRaw.getInsertIntoDesc().getEventTypeName()) != null;
    }

    private static boolean isSubqueryWithTable(List<ExprSubselectNode> subselectNodes, TableCompileTimeResolver tableCompileTimeResolver) {
        for (ExprSubselectNode node : subselectNodes) {
            FilterStreamSpecRaw spec = (FilterStreamSpecRaw)node.getStatementSpecRaw().getStreamSpecs().get(0);
            if (tableCompileTimeResolver.resolve(spec.getRawFilterSpec().getEventTypeName()) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isJoinWithTable(StatementSpecRaw statementSpecRaw, TableCompileTimeResolver tableCompileTimeResolver) {
        for (StreamSpecRaw stream : statementSpecRaw.getStreamSpecs()) {
            FilterStreamSpecRaw filter;
            if (!(stream instanceof FilterStreamSpecRaw) || tableCompileTimeResolver.resolve((filter = (FilterStreamSpecRaw)stream).getRawFilterSpec().getEventTypeName()) == null) continue;
            return true;
        }
        return false;
    }

    public static SelectClauseSpecCompiled compileSelectClause(SelectClauseSpecRaw spec) {
        ArrayList<SelectClauseElementCompiled> selectElements = new ArrayList<SelectClauseElementCompiled>();
        for (SelectClauseElementRaw raw : spec.getSelectExprList()) {
            SelectClauseElementRaw rawExpr;
            if (raw instanceof SelectClauseExprRawSpec) {
                rawExpr = (SelectClauseExprRawSpec)raw;
                selectElements.add(new SelectClauseExprCompiledSpec(((SelectClauseExprRawSpec)rawExpr).getSelectExpression(), ((SelectClauseExprRawSpec)rawExpr).getOptionalAsName(), ((SelectClauseExprRawSpec)rawExpr).getOptionalAsName(), ((SelectClauseExprRawSpec)rawExpr).isEvents()));
                continue;
            }
            if (raw instanceof SelectClauseStreamRawSpec) {
                rawExpr = (SelectClauseStreamRawSpec)raw;
                selectElements.add(new SelectClauseStreamCompiledSpec(((SelectClauseStreamRawSpec)rawExpr).getStreamName(), ((SelectClauseStreamRawSpec)rawExpr).getOptionalAsName()));
                continue;
            }
            if (raw instanceof SelectClauseElementWildcard) {
                SelectClauseElementWildcard wildcard = (SelectClauseElementWildcard)raw;
                selectElements.add(wildcard);
                continue;
            }
            throw new IllegalStateException("Unexpected select clause element class : " + raw.getClass().getName());
        }
        return new SelectClauseSpecCompiled(selectElements.toArray(new SelectClauseElementCompiled[selectElements.size()]), spec.isDistinct());
    }

    public static boolean isWritesToTables(StatementSpecRaw statementSpec, TableCompileTimeResolver tableCompileTimeResolver) {
        FireAndForgetSpec faf;
        if (statementSpec.getInsertIntoDesc() != null && StatementLifecycleSvcUtil.isTable(statementSpec.getInsertIntoDesc().getEventTypeName(), tableCompileTimeResolver)) {
            return true;
        }
        if (statementSpec.getIntoTableSpec() != null) {
            return true;
        }
        if (statementSpec.getOnTriggerDesc() != null) {
            OnTriggerDesc onTriggerDesc = statementSpec.getOnTriggerDesc();
            if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_SPLITSTREAM) {
                OnTriggerSplitStreamDesc split = (OnTriggerSplitStreamDesc)onTriggerDesc;
                for (OnTriggerSplitStream stream : split.getSplitStreams()) {
                    if (stream.getInsertInto() == null || !StatementLifecycleSvcUtil.isTable(stream.getInsertInto().getEventTypeName(), tableCompileTimeResolver)) continue;
                    return true;
                }
            }
            if (onTriggerDesc instanceof OnTriggerWindowDesc) {
                OnTriggerWindowDesc window = (OnTriggerWindowDesc)onTriggerDesc;
                if ((onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_DELETE || onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_UPDATE || onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_MERGE || window.isDeleteAndSelect()) && StatementLifecycleSvcUtil.isTable(window.getWindowName(), tableCompileTimeResolver)) {
                    return true;
                }
            }
            if (onTriggerDesc instanceof OnTriggerMergeDesc) {
                OnTriggerMergeDesc merge = (OnTriggerMergeDesc)onTriggerDesc;
                for (OnTriggerMergeMatched item : merge.getItems()) {
                    for (OnTriggerMergeAction action : item.getActions()) {
                        if (!StatementLifecycleSvcUtil.checkOnTriggerMergeAction(action, tableCompileTimeResolver)) continue;
                        return true;
                    }
                }
                if (merge.getOptionalInsertNoMatch() != null && StatementLifecycleSvcUtil.checkOnTriggerMergeAction(merge.getOptionalInsertNoMatch(), tableCompileTimeResolver)) {
                    return true;
                }
            }
        }
        if (statementSpec.getFireAndForgetSpec() != null && ((faf = statementSpec.getFireAndForgetSpec()) instanceof FireAndForgetSpecDelete || faf instanceof FireAndForgetSpecInsert || faf instanceof FireAndForgetSpecUpdate) && statementSpec.getStreamSpecs().size() == 1) {
            return StatementLifecycleSvcUtil.isTable(((FilterStreamSpecRaw)statementSpec.getStreamSpecs().get(0)).getRawFilterSpec().getEventTypeName(), tableCompileTimeResolver);
        }
        return false;
    }

    private static boolean checkOnTriggerMergeAction(OnTriggerMergeAction action, TableCompileTimeResolver tableCompileTimeResolver) {
        OnTriggerMergeActionInsert insert;
        return action instanceof OnTriggerMergeActionInsert && (insert = (OnTriggerMergeActionInsert)action).getOptionalStreamName() != null && StatementLifecycleSvcUtil.isTable(insert.getOptionalStreamName(), tableCompileTimeResolver);
    }

    private static boolean isTable(String name, TableCompileTimeResolver tableCompileTimeResolver) {
        return tableCompileTimeResolver.resolve(name) != null;
    }
}

