/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createcontext;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.context.ContextStateEventContextCreated;
import com.espertech.esper.common.client.context.ContextStateListener;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIncidentals;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactory;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryResult;
import com.espertech.esper.common.internal.context.aifactory.createcontext.StatementAgentInstanceFactoryCreateContextResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.mgr.ContextManager;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.mgr.ContextStateEventUtil;
import com.espertech.esper.common.internal.context.module.StatementReadyCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.context.util.UndeployPreconditionException;
import com.espertech.esper.common.internal.view.core.ZeroDepthStreamNoIterate;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;

public class StatementAgentInstanceFactoryCreateContext
implements StatementAgentInstanceFactory,
StatementReadyCallback {
    private String contextName;
    private EventType statementEventType;

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void setStatementEventType(EventType statementEventType) {
        this.statementEventType = statementEventType;
    }

    @Override
    public void ready(StatementContext statementContext, ModuleIncidentals moduleIncidentals, boolean recovery) {
        ContextManager contextManager = statementContext.getContextManagementService().getContextManager(statementContext.getDeploymentId(), this.contextName);
        contextManager.setStatementContext(statementContext);
    }

    @Override
    public StatementAgentInstanceFactoryResult newContext(AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        ContextManager manager = agentInstanceContext.getContextManagementService().getContextManager(agentInstanceContext.getDeploymentId(), this.contextName);
        agentInstanceContext.getEpStatementAgentInstanceHandle().setFilterFaultHandler(manager);
        ContextManagerRealization realization = manager.allocateNewRealization(agentInstanceContext);
        return new StatementAgentInstanceFactoryCreateContextResult(new ZeroDepthStreamNoIterate(this.statementEventType), AgentInstanceStopCallback.INSTANCE_NO_ACTION, agentInstanceContext, null, null, null, null, null, null, Collections.emptyList(), realization);
    }

    @Override
    public void statementCreate(StatementContext statementContext) {
        CopyOnWriteArrayList<ContextStateListener> listeners = statementContext.getContextManagementService().getListeners();
        ContextStateEventUtil.dispatchContext(listeners, () -> new ContextStateEventContextCreated(statementContext.getRuntimeURI(), statementContext.getDeploymentId(), this.contextName), ContextStateListener::onContextCreated);
    }

    @Override
    public void statementDestroyPreconditions(StatementContext statementContext) throws UndeployPreconditionException {
        ContextManager manager = statementContext.getContextManagementService().getContextManager(statementContext.getDeploymentId(), this.contextName);
        int count = manager.countStatements(stmt -> !stmt.getDeploymentId().equals(statementContext.getDeploymentId()));
        if (count != 0) {
            throw new UndeployPreconditionException("Context by name '" + this.contextName + "' is still referenced by statements and may not be undeployed");
        }
    }

    @Override
    public void statementDestroy(StatementContext statementContext) {
        statementContext.getContextManagementService().destroyedContext(statementContext.getRuntimeURI(), statementContext.getDeploymentId(), this.contextName);
    }

    @Override
    public EventType getStatementEventType() {
        return this.statementEventType;
    }

    @Override
    public AIRegistryRequirements getRegistryRequirements() {
        return AIRegistryRequirements.noRequirements();
    }

    @Override
    public StatementAgentInstanceLock obtainAgentInstanceLock(StatementContext statementContext, int agentInstanceId) {
        return AgentInstanceUtil.newLock(statementContext);
    }
}

