/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createdataflow;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.dataflow.annotations.DataFlowOpPropertyHolder;
import com.espertech.esper.common.client.dataflow.annotations.DataFlowOpProvideSignal;
import com.espertech.esper.common.client.dataflow.annotations.OutputType;
import com.espertech.esper.common.client.dataflow.annotations.OutputTypes;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowOperatorParameterProvider;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.client.util.StatementProperty;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateDataFlowDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateSchemaDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.GraphOperatorInput;
import com.espertech.esper.common.internal.compile.stage1.spec.GraphOperatorInputNamesAlias;
import com.espertech.esper.common.internal.compile.stage1.spec.GraphOperatorOutputItem;
import com.espertech.esper.common.internal.compile.stage1.spec.GraphOperatorOutputItemType;
import com.espertech.esper.common.internal.compile.stage1.spec.GraphOperatorSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompileException;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StatementInformationalsUtil;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableStmtFields;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableStmtProvider;
import com.espertech.esper.common.internal.compile.stage3.StmtForgeMethod;
import com.espertech.esper.common.internal.compile.stage3.StmtForgeMethodResult;
import com.espertech.esper.common.internal.context.aifactory.createdataflow.DataflowDescForge;
import com.espertech.esper.common.internal.context.aifactory.createdataflow.StatementAgentInstanceFactoryCreateDataflowForge;
import com.espertech.esper.common.internal.context.aifactory.createdataflow.StmtClassForgeableAIFactoryProviderCreateDataflow;
import com.espertech.esper.common.internal.context.module.StatementAIFactoryProvider;
import com.espertech.esper.common.internal.context.module.StatementFields;
import com.espertech.esper.common.internal.context.module.StatementInformationalsCompileTime;
import com.espertech.esper.common.internal.context.module.StatementProvider;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeCodegenEnv;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeResult;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpInputPort;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpOutputPort;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOperatorForge;
import com.espertech.esper.common.internal.epl.dataflow.ops.EventBusSourceForge;
import com.espertech.esper.common.internal.epl.dataflow.realize.LogicalChannel;
import com.espertech.esper.common.internal.epl.dataflow.realize.LogicalChannelProducingPortCompiled;
import com.espertech.esper.common.internal.epl.dataflow.realize.LogicalChannelProducingPortDeclared;
import com.espertech.esper.common.internal.epl.dataflow.realize.LogicalChannelUtil;
import com.espertech.esper.common.internal.epl.dataflow.util.GraphTypeDesc;
import com.espertech.esper.common.internal.epl.dataflow.util.OperatorDependencyEntry;
import com.espertech.esper.common.internal.epl.dataflow.util.OperatorMetadataDescriptor;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.PopulateUtil;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectSubscriberDescriptor;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventTypeForgablesPair;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamExprNodeForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.util.DependencyGraph;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StmtForgeMethodCreateDataflow
implements StmtForgeMethod {
    private static final String EVENT_WRAPPED_TYPE = "eventbean";
    private static final Logger log = LoggerFactory.getLogger(StmtForgeMethodCreateDataflow.class);
    private final StatementBaseInfo base;

    public StmtForgeMethodCreateDataflow(StatementBaseInfo base) {
        this.base = base;
    }

    @Override
    public StmtForgeMethodResult make(String packageName, String classPostfix, StatementCompileTimeServices services) throws ExprValidationException {
        StatementSpecCompiled statementSpec = this.base.getStatementSpec();
        CreateDataFlowDesc createDataFlowDesc = statementSpec.getRaw().getCreateDataFlowDesc();
        services.getDataFlowCompileTimeRegistry().newDataFlow(createDataFlowDesc.getGraphName());
        String eventTypeName = services.getEventTypeNameGeneratorStatement().getAnonymousTypeName();
        EventTypeMetadata metadata = new EventTypeMetadata(eventTypeName, this.base.getModuleName(), EventTypeTypeClass.STATEMENTOUT, EventTypeApplicationType.MAP, NameAccessModifier.TRANSIENT, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
        MapEventType eventType = BaseNestableEventUtil.makeMapTypeCompileTime(metadata, Collections.emptyMap(), null, null, null, null, services.getBeanEventTypeFactoryPrivate(), services.getEventTypeCompileTimeResolver());
        services.getEventTypeCompileTimeRegistry().newType(eventType);
        String statementFieldsClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementFields.class, classPostfix);
        DataFlowOpForgeCodegenEnv codegenEnv = new DataFlowOpForgeCodegenEnv(packageName, classPostfix);
        DataflowDescForge dataflowForge = StmtForgeMethodCreateDataflow.buildForge(createDataFlowDesc, codegenEnv, packageName, this.base, services);
        CodegenPackageScope packageScope = new CodegenPackageScope(packageName, statementFieldsClassName, services.isInstrumented());
        String aiFactoryProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementAIFactoryProvider.class, classPostfix);
        StatementAgentInstanceFactoryCreateDataflowForge forge = new StatementAgentInstanceFactoryCreateDataflowForge(eventType, dataflowForge);
        StmtClassForgeableAIFactoryProviderCreateDataflow aiFactoryForgeable = new StmtClassForgeableAIFactoryProviderCreateDataflow(aiFactoryProviderClassName, packageScope, forge);
        SelectSubscriberDescriptor selectSubscriberDescriptor = new SelectSubscriberDescriptor();
        StatementInformationalsCompileTime informationals = StatementInformationalsUtil.getInformationals(this.base, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, selectSubscriberDescriptor, packageScope, services);
        informationals.getProperties().put(StatementProperty.CREATEOBJECTNAME, createDataFlowDesc.getGraphName());
        String statementProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementProvider.class, classPostfix);
        StmtClassForgeableStmtProvider stmtProvider = new StmtClassForgeableStmtProvider(aiFactoryProviderClassName, statementProviderClassName, informationals, packageScope);
        ArrayList<StmtClassForgeable> forgeables = new ArrayList<StmtClassForgeable>();
        for (StmtClassForgeableFactory stmtClassForgeableFactory : dataflowForge.getAdditionalForgables()) {
            forgeables.add(stmtClassForgeableFactory.make(packageScope, classPostfix));
        }
        forgeables.add(aiFactoryForgeable);
        forgeables.add(stmtProvider);
        forgeables.add(new StmtClassForgeableStmtFields(statementFieldsClassName, packageScope, 0));
        ArrayList<FilterSpecCompiled> filterSpecCompileds = new ArrayList<FilterSpecCompiled>();
        for (Map.Entry<Integer, DataFlowOperatorForge> entry : dataflowForge.getOperatorFactories().entrySet()) {
            if (!(entry.getValue() instanceof EventBusSourceForge)) continue;
            EventBusSourceForge eventBusSource = (EventBusSourceForge)entry.getValue();
            filterSpecCompileds.add(eventBusSource.getFilterSpecCompiled());
        }
        List<FilterSpecParamExprNodeForge> list = FilterSpecCompiled.makeExprNodeList(filterSpecCompileds, Collections.emptyList());
        ArrayList<NamedWindowConsumerStreamSpec> arrayList = new ArrayList<NamedWindowConsumerStreamSpec>();
        ArrayList<ScheduleHandleCallbackProvider> scheduleds = new ArrayList<ScheduleHandleCallbackProvider>();
        for (StmtForgeMethodResult additional : dataflowForge.getForgables()) {
            forgeables.addAll(0, additional.getForgeables());
            scheduleds.addAll(additional.getScheduleds());
        }
        return new StmtForgeMethodResult(forgeables, filterSpecCompileds, scheduleds, arrayList, list);
    }

    private static DataflowDescForge buildForge(CreateDataFlowDesc desc, DataFlowOpForgeCodegenEnv codegenEnv, String packageName, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        StmtForgeMethodCreateDataflow.validate(desc);
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        HashMap<Integer, Annotation[]> operatorAnnotations = new HashMap<Integer, Annotation[]>();
        int count = 0;
        for (GraphOperatorSpec spec : desc.getOperators()) {
            Annotation[] operatorAnnotation;
            try {
                operatorAnnotation = AnnotationUtil.compileAnnotations(spec.getAnnotations(), services.getClasspathImportServiceCompileTime(), null);
            }
            catch (StatementSpecCompileException e) {
                throw new ExprValidationException("Invalid annotation: " + e.getMessage(), e);
            }
            operatorAnnotations.put(count, operatorAnnotation);
            ++count;
        }
        ResolveTypesResult resolveTypesResult = StmtForgeMethodCreateDataflow.resolveTypes(desc, packageName, base, services);
        Map declaredTypes = resolveTypesResult.types;
        additionalForgeables.addAll(resolveTypesResult.additionalForgeables);
        Map<Integer, OperatorMetadataDescriptor> operatorMetadata = StmtForgeMethodCreateDataflow.resolveMetadata(desc, operatorAnnotations, base, services);
        Map<Integer, OperatorDependencyEntry> operatorDependencies = StmtForgeMethodCreateDataflow.analyzeDependencies(desc);
        Set<Integer> operatorBuildOrder = StmtForgeMethodCreateDataflow.analyzeBuildOrder(operatorDependencies);
        Map<Integer, DataFlowOperatorForge> operatorForges = StmtForgeMethodCreateDataflow.instantiateOperatorForges(operatorDependencies, operatorMetadata, operatorAnnotations, declaredTypes, desc, base, services);
        InitForgesResult initForgesResult = StmtForgeMethodCreateDataflow.determineChannelsInitForges(operatorForges, operatorBuildOrder, operatorAnnotations, operatorDependencies, operatorMetadata, declaredTypes, desc, codegenEnv, base, services);
        if (log.isDebugEnabled()) {
            log.debug("For flow '" + desc.getGraphName() + "' channels are: " + LogicalChannelUtil.printChannels(initForgesResult.logicalChannels));
        }
        return new DataflowDescForge(desc.getGraphName(), declaredTypes, operatorMetadata, operatorBuildOrder, operatorForges, initForgesResult.getLogicalChannels(), initForgesResult.forgables, additionalForgeables);
    }

    private static InitForgesResult determineChannelsInitForges(Map<Integer, DataFlowOperatorForge> operatorForges, Set<Integer> operatorBuildOrder, Map<Integer, Annotation[]> operatorAnnotations, Map<Integer, OperatorDependencyEntry> operatorDependencies, Map<Integer, OperatorMetadataDescriptor> operatorMetadata, Map<String, EventType> declaredTypes, CreateDataFlowDesc desc, DataFlowOpForgeCodegenEnv codegenEnv, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        Object metadata;
        HashMap<Integer, List<LogicalChannelProducingPortDeclared>> declaredOutputPorts = new HashMap<Integer, List<LogicalChannelProducingPortDeclared>>();
        for (int operatorNum : operatorBuildOrder) {
            metadata = operatorMetadata.get(operatorNum);
            DataFlowOperatorForge operatorForge = operatorForges.get(operatorNum);
            GraphOperatorSpec operatorSpec = desc.getOperators().get(operatorNum);
            List<LogicalChannelProducingPortDeclared> annotationPorts = StmtForgeMethodCreateDataflow.determineAnnotatedOutputPorts(operatorNum, operatorForge, operatorSpec, (OperatorMetadataDescriptor)metadata, base, services);
            List<LogicalChannelProducingPortDeclared> graphDeclaredPorts = StmtForgeMethodCreateDataflow.determineGraphDeclaredOutputPorts(operatorNum, operatorForge, operatorSpec, (OperatorMetadataDescriptor)metadata, declaredTypes, services);
            ArrayList<LogicalChannelProducingPortDeclared> allDeclaredPorts = new ArrayList<LogicalChannelProducingPortDeclared>();
            allDeclaredPorts.addAll(annotationPorts);
            allDeclaredPorts.addAll(graphDeclaredPorts);
            declaredOutputPorts.put(operatorNum, allDeclaredPorts);
        }
        HashMap<Integer, List<LogicalChannelProducingPortCompiled>> compiledOutputPorts = new HashMap<Integer, List<LogicalChannelProducingPortCompiled>>();
        ArrayList<StmtForgeMethodResult> additionalForgeables = new ArrayList<StmtForgeMethodResult>();
        metadata = operatorBuildOrder.iterator();
        while (metadata.hasNext()) {
            int operatorNum = (Integer)metadata.next();
            OperatorMetadataDescriptor metadata2 = operatorMetadata.get(operatorNum);
            DataFlowOperatorForge operatorForge = operatorForges.get(operatorNum);
            GraphOperatorSpec operatorSpec = desc.getOperators().get(operatorNum);
            Annotation[] operatorAnno = operatorAnnotations.get(operatorNum);
            Set<Integer> incomingDependentOpNums = operatorDependencies.get(operatorNum).getIncoming();
            DataFlowOpForgeInitializeResult initializeResult = StmtForgeMethodCreateDataflow.initializeOperatorForge(operatorNum, operatorForge, operatorAnno, metadata2, operatorSpec, declaredOutputPorts, compiledOutputPorts, declaredTypes, incomingDependentOpNums, desc, codegenEnv, base, services);
            GraphTypeDesc[] typesPerOutput = null;
            if (initializeResult != null) {
                typesPerOutput = initializeResult.getTypeDescriptors();
                if (initializeResult.getAdditionalForgeables() != null) {
                    additionalForgeables.add(initializeResult.getAdditionalForgeables());
                }
            }
            List<LogicalChannelProducingPortCompiled> outgoingPorts = StmtForgeMethodCreateDataflow.determineOutgoingPorts(operatorNum, operatorSpec, metadata2, compiledOutputPorts, declaredOutputPorts, typesPerOutput, incomingDependentOpNums);
            compiledOutputPorts.put(operatorNum, outgoingPorts);
        }
        ArrayList<LogicalChannel> channels = new ArrayList<LogicalChannel>();
        int channelId = 0;
        for (Integer operatorNum : operatorBuildOrder) {
            OperatorDependencyEntry dependencies = operatorDependencies.get(operatorNum);
            GraphOperatorSpec operatorSpec = desc.getOperators().get(operatorNum);
            List<GraphOperatorInputNamesAlias> inputNames = operatorSpec.getInput().getStreamNamesAndAliases();
            OperatorMetadataDescriptor descriptor = operatorMetadata.get(operatorNum);
            int streamNum = -1;
            for (GraphOperatorInputNamesAlias inputName : inputNames) {
                ++streamNum;
                List<LogicalChannelProducingPortCompiled> producingPorts = LogicalChannelUtil.getOutputPortByStreamName(dependencies.getIncoming(), inputName.getInputStreamNames(), compiledOutputPorts);
                if (producingPorts.size() < inputName.getInputStreamNames().length) {
                    throw new IllegalStateException("Failed to find producing ports");
                }
                if (producingPorts.size() > 1) {
                    LogicalChannelProducingPortCompiled first = producingPorts.get(0);
                    for (int i = 1; i < producingPorts.size(); ++i) {
                        LogicalChannelProducingPortCompiled other = producingPorts.get(i);
                        StmtForgeMethodCreateDataflow.compareTypeInfo(descriptor.getOperatorName(), first.getStreamName(), first.getGraphTypeDesc(), other.getStreamName(), other.getGraphTypeDesc());
                    }
                }
                String optionalAlias = inputName.getOptionalAsName();
                for (String streamName : inputName.getInputStreamNames()) {
                    for (LogicalChannelProducingPortCompiled port : producingPorts) {
                        if (!port.getStreamName().equals(streamName)) continue;
                        LogicalChannel channel = new LogicalChannel(channelId++, descriptor.getOperatorName(), operatorNum, streamNum, streamName, optionalAlias, descriptor.getOperatorPrettyPrint(), port);
                        channels.add(channel);
                    }
                }
            }
        }
        return new InitForgesResult(channels, additionalForgeables);
    }

    private static Map<Integer, DataFlowOperatorForge> instantiateOperatorForges(Map<Integer, OperatorDependencyEntry> operatorDependencies, Map<Integer, OperatorMetadataDescriptor> operatorMetadata, Map<Integer, Annotation[]> operatorAnnotations, Map<String, EventType> declaredTypes, CreateDataFlowDesc createDataFlowDesc, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        HashMap<Integer, DataFlowOperatorForge> forges = new HashMap<Integer, DataFlowOperatorForge>();
        for (Map.Entry<Integer, OperatorMetadataDescriptor> entry : operatorMetadata.entrySet()) {
            DataFlowOperatorForge forge = StmtForgeMethodCreateDataflow.instantiateOperatorForge(createDataFlowDesc, entry.getKey(), entry.getValue(), base, services);
            forges.put(entry.getKey(), forge);
        }
        return forges;
    }

    private static DataFlowOperatorForge instantiateOperatorForge(CreateDataFlowDesc createDataFlowDesc, int operatorNum, OperatorMetadataDescriptor desc, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        Object forgeObject;
        GraphOperatorSpec operatorSpec = createDataFlowDesc.getOperators().get(operatorNum);
        String dataflowName = createDataFlowDesc.getGraphName();
        Class clazz = desc.getForgeClass();
        try {
            forgeObject = clazz.newInstance();
        }
        catch (Exception e) {
            throw new ExprValidationException("Failed to instantiate: " + e.getMessage());
        }
        ExprValidationContext exprValidationContext = new ExprValidationContextBuilder(new StreamTypeServiceImpl(false), base.getStatementRawInfo(), services).build();
        Map<String, Object> configs = operatorSpec.getDetail() == null ? Collections.emptyMap() : operatorSpec.getDetail().getConfigs();
        StmtForgeMethodCreateDataflow.injectObjectProperties(dataflowName, operatorSpec.getOperatorName(), operatorNum, configs, forgeObject, null, null, exprValidationContext);
        if (!(forgeObject instanceof DataFlowOperatorForge)) {
            throw new ExprValidationException("Operator object '" + forgeObject.getClass().getSimpleName() + "' does not implement the '" + DataFlowOperatorForge.class + "' interface ");
        }
        return (DataFlowOperatorForge)forgeObject;
    }

    private static Map<Integer, DataFlowOpInputPort> getInputPorts(int operatorNumber, GraphOperatorSpec operatorSpec, Set<Integer> incomingDependentOpNums, Map<Integer, List<LogicalChannelProducingPortDeclared>> declaredOutputPorts, Map<Integer, List<LogicalChannelProducingPortCompiled>> compiledOutputPorts) throws ExprValidationException {
        int numDeclared = operatorSpec.getInput().getStreamNamesAndAliases().size();
        LinkedHashMap<Integer, DataFlowOpInputPort> inputPorts = new LinkedHashMap<Integer, DataFlowOpInputPort>();
        for (int inputPortNum = 0; inputPortNum < numDeclared; ++inputPortNum) {
            DataFlowOpInputPort port;
            GraphOperatorInputNamesAlias inputItem = operatorSpec.getInput().getStreamNamesAndAliases().get(inputPortNum);
            List<LogicalChannelProducingPortCompiled> producingPorts = LogicalChannelUtil.getOutputPortByStreamName(incomingDependentOpNums, inputItem.getInputStreamNames(), compiledOutputPorts);
            if (producingPorts.isEmpty()) {
                List<LogicalChannelProducingPortDeclared> declareds = declaredOutputPorts.get(operatorNumber);
                if (declareds == null || declareds.isEmpty()) {
                    throw new ExprValidationException("Failed validation for operator '" + operatorSpec.getOperatorName() + "': No output ports declared");
                }
                LogicalChannelProducingPortDeclared foundDeclared = null;
                for (LogicalChannelProducingPortDeclared declared : declareds) {
                    if (!Arrays.asList(inputItem.getInputStreamNames()).contains(declared.getStreamName())) continue;
                    foundDeclared = declared;
                    break;
                }
                if (foundDeclared == null) {
                    throw new ExprValidationException("Failed validation for operator '" + operatorSpec.getOperatorName() + "': Failed to find output port declared");
                }
                port = new DataFlowOpInputPort(foundDeclared.getTypeDesc(), new HashSet<String>(Arrays.asList(inputItem.getInputStreamNames())), inputItem.getOptionalAsName(), false);
            } else {
                port = new DataFlowOpInputPort(new GraphTypeDesc(false, false, producingPorts.get(0).getGraphTypeDesc().getEventType()), new HashSet<String>(Arrays.asList(inputItem.getInputStreamNames())), inputItem.getOptionalAsName(), producingPorts.get(0).isHasPunctuation());
            }
            inputPorts.put(inputPortNum, port);
        }
        return inputPorts;
    }

    private static Map<Integer, OperatorMetadataDescriptor> resolveMetadata(CreateDataFlowDesc desc, Map<Integer, Annotation[]> operatorAnnotations, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        HashMap<Integer, OperatorMetadataDescriptor> operatorClasses = new HashMap<Integer, OperatorMetadataDescriptor>();
        for (int i = 0; i < desc.getOperators().size(); ++i) {
            Class forgeClass;
            Annotation[] operatorAnnotation;
            String operatorPrettyPrint;
            String operatorName;
            int numOutputPorts;
            GraphOperatorSpec operatorSpec;
            block6: {
                operatorSpec = desc.getOperators().get(i);
                numOutputPorts = operatorSpec.getOutput().getItems().size();
                operatorName = operatorSpec.getOperatorName();
                operatorPrettyPrint = StmtForgeMethodCreateDataflow.toPrettyPrint(i, operatorSpec);
                operatorAnnotation = operatorAnnotations.get(i);
                forgeClass = null;
                try {
                    String forgeClassName = operatorSpec.getOperatorName() + "Forge";
                    forgeClass = services.getClasspathImportServiceCompileTime().resolveClass(forgeClassName, false);
                }
                catch (ClasspathImportException e) {
                    try {
                        String forgeClassName = operatorSpec.getOperatorName();
                        forgeClass = services.getClasspathImportServiceCompileTime().resolveClass(forgeClassName, false);
                    }
                    catch (ClasspathImportException classpathImportException) {
                        // empty catch block
                    }
                    if (forgeClass != null) break block6;
                    throw new ExprValidationException("Failed to resolve forge class for operator '" + operatorSpec.getOperatorName() + "': " + e.getMessage(), e);
                }
            }
            if (!JavaClassHelper.isImplementsInterface(forgeClass, DataFlowOperatorForge.class)) {
                throw new ExprValidationException("Forge class for operator '" + operatorSpec.getOperatorName() + "' does not implement interface '" + DataFlowOperatorForge.class.getSimpleName() + "' (class '" + forgeClass.getName() + "')");
            }
            OperatorMetadataDescriptor descriptor = new OperatorMetadataDescriptor(forgeClass, operatorPrettyPrint, operatorAnnotation, numOutputPorts, operatorName);
            operatorClasses.put(i, descriptor);
        }
        return operatorClasses;
    }

    private static ResolveTypesResult resolveTypes(CreateDataFlowDesc desc, String packageName, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        HashMap<String, EventType> types = new HashMap<String, EventType>();
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        for (CreateSchemaDesc spec : desc.getSchemas()) {
            EventTypeForgablesPair forgablesPair = EventTypeUtility.createNonVariantType(true, spec, packageName, base, services);
            additionalForgeables.addAll(forgablesPair.getAdditionalForgeables());
            EventType eventType = forgablesPair.getEventType();
            types.put(spec.getSchemaName(), eventType);
        }
        return new ResolveTypesResult(types, additionalForgeables);
    }

    private static void validate(CreateDataFlowDesc desc) throws ExprValidationException {
        for (GraphOperatorSpec spec : desc.getOperators()) {
            for (GraphOperatorOutputItem out : spec.getOutput().getItems()) {
                if (out.getTypeInfo().size() <= 1) continue;
                throw new ExprValidationException("Failed to validate operator '" + spec.getOperatorName() + "': Multiple output types for a single stream '" + out.getStreamName() + "' are not supported");
            }
        }
        HashSet<String> schemaNames = new HashSet<String>();
        for (CreateSchemaDesc schema : desc.getSchemas()) {
            if (schemaNames.contains(schema.getSchemaName())) {
                throw new ExprValidationException("Schema name '" + schema.getSchemaName() + "' is declared more then once");
            }
            schemaNames.add(schema.getSchemaName());
        }
    }

    private static String toPrettyPrint(int operatorNum, GraphOperatorSpec spec) {
        StringWriter writer = new StringWriter();
        writer.write(spec.getOperatorName());
        writer.write("#");
        writer.write(Integer.toString(operatorNum));
        writer.write("(");
        String delimiter = "";
        for (GraphOperatorInputNamesAlias inputItem : spec.getInput().getStreamNamesAndAliases()) {
            writer.write(delimiter);
            StmtForgeMethodCreateDataflow.toPrettyPrintInput(inputItem, writer);
            if (inputItem.getOptionalAsName() != null) {
                writer.write(" as ");
                writer.write(inputItem.getOptionalAsName());
            }
            delimiter = ", ";
        }
        writer.write(")");
        if (spec.getOutput().getItems().isEmpty()) {
            return writer.toString();
        }
        writer.write(" -> ");
        delimiter = "";
        for (GraphOperatorOutputItem outputItem : spec.getOutput().getItems()) {
            writer.write(delimiter);
            writer.write(outputItem.getStreamName());
            StmtForgeMethodCreateDataflow.writeTypes(outputItem.getTypeInfo(), writer);
            delimiter = ",";
        }
        return writer.toString();
    }

    private static void toPrettyPrintInput(GraphOperatorInputNamesAlias inputItem, StringWriter writer) {
        if (inputItem.getInputStreamNames().length == 1) {
            writer.write(inputItem.getInputStreamNames()[0]);
        } else {
            writer.write("(");
            String delimiterNames = "";
            for (String name : inputItem.getInputStreamNames()) {
                writer.write(delimiterNames);
                writer.write(name);
                delimiterNames = ",";
            }
            writer.write(")");
        }
    }

    private static void writeTypes(List<GraphOperatorOutputItemType> types, StringWriter writer) {
        if (types.isEmpty()) {
            return;
        }
        writer.write("<");
        String typeDelimiter = "";
        for (GraphOperatorOutputItemType type : types) {
            writer.write(typeDelimiter);
            StmtForgeMethodCreateDataflow.writeType(type, writer);
            typeDelimiter = ",";
        }
        writer.write(">");
    }

    private static void writeType(GraphOperatorOutputItemType type, StringWriter writer) {
        if (type.isWildcard()) {
            writer.append('?');
            return;
        }
        writer.append(type.getTypeOrClassname());
        StmtForgeMethodCreateDataflow.writeTypes(type.getTypeParameters(), writer);
    }

    private static Map<Integer, OperatorDependencyEntry> analyzeDependencies(CreateDataFlowDesc graphDesc) throws ExprValidationException {
        OperatorDependencyEntry entry;
        HashMap<Integer, OperatorDependencyEntry> logicalOpDependencies = new HashMap<Integer, OperatorDependencyEntry>();
        for (int i = 0; i < graphDesc.getOperators().size(); ++i) {
            entry = new OperatorDependencyEntry();
            logicalOpDependencies.put(i, entry);
        }
        for (int consumingOpNum = 0; consumingOpNum < graphDesc.getOperators().size(); ++consumingOpNum) {
            entry = (OperatorDependencyEntry)logicalOpDependencies.get(consumingOpNum);
            GraphOperatorSpec op = graphDesc.getOperators().get(consumingOpNum);
            for (GraphOperatorInputNamesAlias input : op.getInput().getStreamNamesAndAliases()) {
                for (String inputStreamName : input.getInputStreamNames()) {
                    boolean found = false;
                    for (int providerOpNum = 0; providerOpNum < graphDesc.getOperators().size(); ++providerOpNum) {
                        GraphOperatorSpec from = graphDesc.getOperators().get(providerOpNum);
                        for (GraphOperatorOutputItem outputItem : from.getOutput().getItems()) {
                            if (!outputItem.getStreamName().equals(inputStreamName)) continue;
                            found = true;
                            entry.addIncoming(providerOpNum);
                            ((OperatorDependencyEntry)logicalOpDependencies.get(providerOpNum)).addOutgoing(consumingOpNum);
                        }
                    }
                    if (found) continue;
                    throw new ExprValidationException("Input stream '" + inputStreamName + "' consumed by operator '" + op.getOperatorName() + "' could not be found");
                }
            }
        }
        return logicalOpDependencies;
    }

    private static Set<Integer> analyzeBuildOrder(Map<Integer, OperatorDependencyEntry> operators) throws ExprValidationException {
        DependencyGraph graph = new DependencyGraph(operators.size(), true);
        for (Map.Entry<Integer, OperatorDependencyEntry> entry : operators.entrySet()) {
            int myOpNum = entry.getKey();
            Set<Integer> incomings = entry.getValue().getIncoming();
            for (int incoming : incomings) {
                if (myOpNum == incoming) continue;
                graph.addDependency(myOpNum, incoming);
            }
        }
        LinkedHashSet<Integer> topDownSet = new LinkedHashSet<Integer>();
        while (topDownSet.size() < operators.size()) {
            TreeSet<Integer> rootNodes = new TreeSet<Integer>(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return -1 * o1.compareTo(o2);
                }
            });
            rootNodes.addAll(graph.getRootNodes(topDownSet));
            if (rootNodes.isEmpty()) {
                for (int i = 0; i < operators.size(); ++i) {
                    if (topDownSet.contains(i)) continue;
                    rootNodes.add(i);
                    break;
                }
            }
            topDownSet.addAll(rootNodes);
        }
        LinkedHashSet<Integer> inverted = new LinkedHashSet<Integer>();
        Integer[] arr = topDownSet.toArray(new Integer[topDownSet.size()]);
        for (int i = arr.length - 1; i >= 0; --i) {
            inverted.add(arr[i]);
        }
        return inverted;
    }

    private static void injectObjectProperties(String dataFlowName, String operatorName, int operatorNum, Map<String, Object> configs, Object instance, EPDataFlowOperatorParameterProvider optionalParameterProvider, Map<String, Object> optionalParameterURIs, ExprValidationContext exprValidationContext) throws ExprValidationException {
        Object propertyInstance;
        Set<Field> propertyHolderFields = JavaClassHelper.findAnnotatedFields(instance.getClass(), DataFlowOpPropertyHolder.class);
        if (propertyHolderFields.size() > 1) {
            throw new IllegalArgumentException("May apply " + DataFlowOpPropertyHolder.class.getSimpleName() + " annotation only to a single field");
        }
        if (propertyHolderFields.isEmpty()) {
            propertyInstance = instance;
        } else {
            Class<?> propertyHolderClass = propertyHolderFields.iterator().next().getType();
            try {
                propertyInstance = propertyHolderClass.newInstance();
            }
            catch (Exception e) {
                throw new ExprValidationException("Failed to instantiate '" + propertyHolderClass + "': " + e.getMessage(), e);
            }
        }
        PopulateUtil.populateObject(operatorName, operatorNum, dataFlowName, configs, propertyInstance, ExprNodeOrigin.DATAFLOW, exprValidationContext, optionalParameterProvider, optionalParameterURIs);
        if (!propertyHolderFields.isEmpty()) {
            Field field = propertyHolderFields.iterator().next();
            try {
                field.setAccessible(true);
                field.set(instance, propertyInstance);
            }
            catch (Exception e) {
                throw new ExprValidationException("Failed to set field '" + field.getName() + "': " + e.getMessage(), e);
            }
        }
    }

    private static List<LogicalChannelProducingPortDeclared> determineAnnotatedOutputPorts(int operatorNumber, DataFlowOperatorForge forge, GraphOperatorSpec operatorSpec, OperatorMetadataDescriptor descriptor, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        ArrayList<LogicalChannelProducingPortDeclared> ports = new ArrayList<LogicalChannelProducingPortDeclared>();
        List<Annotation> annotations = JavaClassHelper.getAnnotations(OutputTypes.class, forge.getClass().getDeclaredAnnotations());
        for (Annotation annotation : annotations) {
            OutputType[] outputTypeArr;
            OutputTypes outputTypes = (OutputTypes)annotation;
            LinkedHashMap<String, Object> propertiesRaw = new LinkedHashMap<String, Object>();
            for (OutputType outputType : outputTypeArr = outputTypes.value()) {
                Class clazz;
                if (outputType.type() != null && outputType.type() != OutputType.class) {
                    clazz = outputType.type();
                } else {
                    String typeName = outputType.typeName();
                    clazz = JavaClassHelper.getClassForSimpleName(typeName, services.getClasspathImportServiceCompileTime().getClassForNameProvider());
                    if (clazz == null) {
                        try {
                            clazz = services.getClasspathImportServiceCompileTime().resolveClass(typeName, false);
                        }
                        catch (ClasspathImportException e) {
                            throw new RuntimeException("Failed to resolve type '" + typeName + "'");
                        }
                    }
                }
                propertiesRaw.put(outputType.name(), clazz);
            }
            LinkedHashMap<String, Object> propertiesCompiled = EventTypeUtility.compileMapTypeProperties(propertiesRaw, services.getEventTypeCompileTimeResolver());
            String eventTypeName = services.getEventTypeNameGeneratorStatement().getDataflowOperatorTypeName(operatorNumber);
            EventTypeMetadata metadata = new EventTypeMetadata(eventTypeName, base.getModuleName(), EventTypeTypeClass.DBDERIVED, EventTypeApplicationType.OBJECTARR, NameAccessModifier.TRANSIENT, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
            ObjectArrayEventType eventType = BaseNestableEventUtil.makeOATypeCompileTime(metadata, propertiesCompiled, null, null, null, null, services.getBeanEventTypeFactoryPrivate(), services.getEventTypeCompileTimeResolver());
            services.getEventTypeCompileTimeRegistry().newType(eventType);
            List<GraphOperatorOutputItem> declaredOutput = operatorSpec.getOutput().getItems();
            if (declaredOutput.isEmpty()) {
                throw new ExprValidationException("No output stream declared");
            }
            if (declaredOutput.size() < outputTypes.portNumber()) {
                throw new ExprValidationException("No output stream declared for this port");
            }
            String streamName = declaredOutput.get(outputTypes.portNumber()).getStreamName();
            boolean isDeclaredPunctuated = JavaClassHelper.isAnnotationListed(DataFlowOpProvideSignal.class, forge.getClass().getAnnotations());
            LogicalChannelProducingPortDeclared port = new LogicalChannelProducingPortDeclared(operatorNumber, descriptor.getOperatorPrettyPrint(), streamName, outputTypes.portNumber(), new GraphTypeDesc(false, false, eventType), isDeclaredPunctuated);
            ports.add(port);
        }
        return ports;
    }

    private static List<LogicalChannelProducingPortDeclared> determineGraphDeclaredOutputPorts(int producingOpNum, DataFlowOperatorForge operatorForge, GraphOperatorSpec operatorSpec, OperatorMetadataDescriptor metadata, Map<String, EventType> types, StatementCompileTimeServices services) throws ExprValidationException {
        ArrayList<LogicalChannelProducingPortDeclared> ports = new ArrayList<LogicalChannelProducingPortDeclared>();
        int portNumber = 0;
        for (GraphOperatorOutputItem outputItem : operatorSpec.getOutput().getItems()) {
            if (outputItem.getTypeInfo().size() > 1) {
                throw new ExprValidationException("Multiple parameter types are not supported");
            }
            if (!outputItem.getTypeInfo().isEmpty()) {
                GraphTypeDesc typeDesc = StmtForgeMethodCreateDataflow.determineTypeOutputPort(outputItem.getTypeInfo().get(0), types, services);
                Class<?> operatorForgeClass = operatorForge.getClass();
                boolean isDeclaredPunctuated = JavaClassHelper.isAnnotationListed(DataFlowOpProvideSignal.class, operatorForgeClass.getAnnotations());
                ports.add(new LogicalChannelProducingPortDeclared(producingOpNum, metadata.getOperatorPrettyPrint(), outputItem.getStreamName(), portNumber, typeDesc, isDeclaredPunctuated));
            }
            ++portNumber;
        }
        return ports;
    }

    private static GraphTypeDesc determineTypeOutputPort(GraphOperatorOutputItemType outType, Map<String, EventType> types, StatementCompileTimeServices services) throws ExprValidationException {
        EventType eventType = null;
        boolean isWildcard = false;
        boolean isUnderlying = true;
        String typeOrClassname = outType.getTypeOrClassname();
        if (typeOrClassname != null && typeOrClassname.toLowerCase(Locale.ENGLISH).equals(EVENT_WRAPPED_TYPE)) {
            isUnderlying = false;
            if (!outType.getTypeParameters().isEmpty() && !outType.getTypeParameters().get(0).isWildcard()) {
                String typeName = outType.getTypeParameters().get(0).getTypeOrClassname();
                eventType = StmtForgeMethodCreateDataflow.resolveType(typeName, types, services);
            } else {
                isWildcard = true;
            }
        } else if (typeOrClassname != null) {
            eventType = StmtForgeMethodCreateDataflow.resolveType(typeOrClassname, types, services);
        } else {
            isWildcard = true;
        }
        return new GraphTypeDesc(isWildcard, isUnderlying, eventType);
    }

    private static EventType resolveType(String typeOrClassname, Map<String, EventType> types, StatementCompileTimeServices services) throws ExprValidationException {
        EventType eventType = types.get(typeOrClassname);
        if (eventType == null) {
            eventType = services.getEventTypeCompileTimeResolver().getTypeByName(typeOrClassname);
        }
        if (eventType == null) {
            throw new ExprValidationException("Failed to find event type '" + typeOrClassname + "'");
        }
        return eventType;
    }

    private static DataFlowOpForgeInitializeResult initializeOperatorForge(int operatorNumber, DataFlowOperatorForge forge, Annotation[] operatorAnnotations, OperatorMetadataDescriptor meta, GraphOperatorSpec operatorSpec, Map<Integer, List<LogicalChannelProducingPortDeclared>> declaredOutputPorts, Map<Integer, List<LogicalChannelProducingPortCompiled>> compiledOutputPorts, Map<String, EventType> types, Set<Integer> incomingDependentOpNums, CreateDataFlowDesc desc, DataFlowOpForgeCodegenEnv codegenEnv, StatementBaseInfo base, StatementCompileTimeServices services) throws ExprValidationException {
        DataFlowOpForgeInitializeResult initializeResult;
        int numDeclared = operatorSpec.getInput().getStreamNamesAndAliases().size();
        LinkedHashMap<Integer, DataFlowOpInputPort> inputPorts = new LinkedHashMap<Integer, DataFlowOpInputPort>();
        for (int inputPortNum = 0; inputPortNum < numDeclared; ++inputPortNum) {
            DataFlowOpInputPort port;
            GraphOperatorInputNamesAlias inputItem = operatorSpec.getInput().getStreamNamesAndAliases().get(inputPortNum);
            List<LogicalChannelProducingPortCompiled> producingPorts = LogicalChannelUtil.getOutputPortByStreamName(incomingDependentOpNums, inputItem.getInputStreamNames(), compiledOutputPorts);
            if (producingPorts.isEmpty()) {
                List<LogicalChannelProducingPortDeclared> declareds = declaredOutputPorts.get(operatorNumber);
                if (declareds == null || declareds.isEmpty()) {
                    throw new ExprValidationException("Failed validation for operator '" + operatorSpec.getOperatorName() + "': No output ports declared");
                }
                LogicalChannelProducingPortDeclared foundDeclared = null;
                for (LogicalChannelProducingPortDeclared declared : declareds) {
                    if (!Arrays.asList(inputItem.getInputStreamNames()).contains(declared.getStreamName())) continue;
                    foundDeclared = declared;
                    break;
                }
                if (foundDeclared == null) {
                    throw new ExprValidationException("Failed validation for operator '" + operatorSpec.getOperatorName() + "': Failed to find output port for input port " + inputPortNum);
                }
                port = new DataFlowOpInputPort(foundDeclared.getTypeDesc(), new HashSet<String>(Arrays.asList(inputItem.getInputStreamNames())), inputItem.getOptionalAsName(), false);
            } else {
                port = new DataFlowOpInputPort(new GraphTypeDesc(false, false, producingPorts.get(0).getGraphTypeDesc().getEventType()), new HashSet<String>(Arrays.asList(inputItem.getInputStreamNames())), inputItem.getOptionalAsName(), producingPorts.get(0).isHasPunctuation());
            }
            inputPorts.put(inputPortNum, port);
        }
        Map<Integer, DataFlowOpOutputPort> outputPorts = StmtForgeMethodCreateDataflow.getDeclaredOutputPorts(operatorSpec, types, services);
        try {
            DataFlowOpForgeInitializeContext context = new DataFlowOpForgeInitializeContext(desc.getGraphName(), operatorNumber, operatorAnnotations, operatorSpec, inputPorts, outputPorts, codegenEnv, base, services);
            initializeResult = forge.initializeForge(context);
        }
        catch (Throwable t) {
            throw new ExprValidationException("Failed to obtain operator '" + operatorSpec.getOperatorName() + "': " + t.getMessage(), t);
        }
        return initializeResult;
    }

    private static List<LogicalChannelProducingPortCompiled> determineOutgoingPorts(int myOpNum, GraphOperatorSpec operatorSpec, OperatorMetadataDescriptor metadata, Map<Integer, List<LogicalChannelProducingPortCompiled>> compiledOutputPorts, Map<Integer, List<LogicalChannelProducingPortDeclared>> declaredOutputPorts, GraphTypeDesc[] typesPerOutput, Set<Integer> incomingDependentOpNums) throws ExprValidationException {
        int numPorts = operatorSpec.getOutput().getItems().size();
        ArrayList<LogicalChannelProducingPortCompiled> result = new ArrayList<LogicalChannelProducingPortCompiled>();
        HashMap<String, GraphTypeDesc> types = new HashMap<String, GraphTypeDesc>();
        for (int port = 0; port < numPorts; ++port) {
            String portStreamName = operatorSpec.getOutput().getItems().get(port).getStreamName();
            LogicalChannelProducingPortDeclared foundDeclared = null;
            List<LogicalChannelProducingPortDeclared> declaredList = declaredOutputPorts.get(myOpNum);
            for (LogicalChannelProducingPortDeclared declared : declaredList) {
                if (declared.getStreamNumber() != port) continue;
                if (foundDeclared != null) {
                    throw new ExprValidationException("Found a declaration twice for port " + port);
                }
                foundDeclared = declared;
            }
            if (foundDeclared == null && (typesPerOutput == null || typesPerOutput.length <= port || typesPerOutput[port] == null)) {
                throw new ExprValidationException("Operator neither declares an output type nor provided by the operator itself in a 'prepare' method");
            }
            if (foundDeclared != null && typesPerOutput != null && typesPerOutput.length > port && typesPerOutput[port] != null) {
                throw new ExprValidationException("Operator both declares an output type and provided a type in the 'prepare' method");
            }
            boolean hasPunctuationSignal = foundDeclared != null && foundDeclared.isHasPunctuation() || StmtForgeMethodCreateDataflow.determineReceivesPunctuation(incomingDependentOpNums, operatorSpec.getInput(), compiledOutputPorts);
            GraphTypeDesc compiledType = foundDeclared != null ? foundDeclared.getTypeDesc() : typesPerOutput[port];
            LogicalChannelProducingPortCompiled compiled = new LogicalChannelProducingPortCompiled(myOpNum, metadata.getOperatorPrettyPrint(), portStreamName, port, compiledType, hasPunctuationSignal);
            result.add(compiled);
            GraphTypeDesc existingType = (GraphTypeDesc)types.get(portStreamName);
            types.put(portStreamName, compiledType);
            if (existingType == null) continue;
            StmtForgeMethodCreateDataflow.compareTypeInfo(operatorSpec.getOperatorName(), portStreamName, existingType, portStreamName, compiledType);
        }
        return result;
    }

    private static boolean determineReceivesPunctuation(Set<Integer> incomingDependentOpNums, GraphOperatorInput input, Map<Integer, List<LogicalChannelProducingPortCompiled>> compiledOutputPorts) {
        for (GraphOperatorInputNamesAlias inputItem : input.getStreamNamesAndAliases()) {
            List<LogicalChannelProducingPortCompiled> list = LogicalChannelUtil.getOutputPortByStreamName(incomingDependentOpNums, inputItem.getInputStreamNames(), compiledOutputPorts);
            for (LogicalChannelProducingPortCompiled port : list) {
                if (!port.isHasPunctuation()) continue;
                return true;
            }
        }
        return false;
    }

    private static void compareTypeInfo(String operatorName, String firstName, GraphTypeDesc firstType, String otherName, GraphTypeDesc otherType) throws ExprValidationException {
        if (firstType.getEventType() != null && otherType.getEventType() != null && !firstType.getEventType().equals(otherType.getEventType())) {
            throw new ExprValidationException("For operator '" + operatorName + "' stream '" + firstName + "' typed '" + firstType.getEventType().getName() + "' is not the same type as stream '" + otherName + "' typed '" + otherType.getEventType().getName() + "'");
        }
        if (firstType.isWildcard() != otherType.isWildcard()) {
            throw new ExprValidationException("For operator '" + operatorName + "' streams '" + firstName + "' and '" + otherName + "' have differing wildcard type information");
        }
        if (firstType.isUnderlying() != otherType.isUnderlying()) {
            throw new ExprValidationException("For operator '" + operatorName + "' streams '" + firstName + "' and '" + otherName + "' have differing underlying information");
        }
    }

    private static Map<Integer, DataFlowOpOutputPort> getDeclaredOutputPorts(GraphOperatorSpec operatorSpec, Map<String, EventType> types, StatementCompileTimeServices services) throws ExprValidationException {
        LinkedHashMap<Integer, DataFlowOpOutputPort> outputPorts = new LinkedHashMap<Integer, DataFlowOpOutputPort>();
        for (int outputPortNum = 0; outputPortNum < operatorSpec.getOutput().getItems().size(); ++outputPortNum) {
            GraphOperatorOutputItem outputItem = operatorSpec.getOutput().getItems().get(outputPortNum);
            GraphTypeDesc typeDesc = null;
            if (!outputItem.getTypeInfo().isEmpty()) {
                typeDesc = StmtForgeMethodCreateDataflow.determineTypeOutputPort(outputItem.getTypeInfo().get(0), types, services);
            }
            outputPorts.put(outputPortNum, new DataFlowOpOutputPort(outputItem.getStreamName(), typeDesc));
        }
        return outputPorts;
    }

    private static class ResolveTypesResult {
        private final Map<String, EventType> types;
        private final List<StmtClassForgeableFactory> additionalForgeables;

        public ResolveTypesResult(Map<String, EventType> types, List<StmtClassForgeableFactory> additionalForgeables) {
            this.types = types;
            this.additionalForgeables = additionalForgeables;
        }

        public Map<String, EventType> getTypes() {
            return this.types;
        }

        public List<StmtClassForgeableFactory> getAdditionalForgeables() {
            return this.additionalForgeables;
        }
    }

    private static class InitForgesResult {
        private final List<LogicalChannel> logicalChannels;
        private final List<StmtForgeMethodResult> forgables;

        public InitForgesResult(List<LogicalChannel> logicalChannels, List<StmtForgeMethodResult> forgables) {
            this.logicalChannels = logicalChannels;
            this.forgables = forgables;
        }

        public List<LogicalChannel> getLogicalChannels() {
            return this.logicalChannels;
        }

        public List<StmtForgeMethodResult> getForgables() {
            return this.forgables;
        }
    }
}

