/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.select;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.activator.ViewableActivationResult;
import com.espertech.esper.common.internal.context.activator.ViewableActivator;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorNamedWindow;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactory;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryUtil;
import com.espertech.esper.common.internal.context.aifactory.select.StatementAgentInstanceFactorySelectResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirementSubquery;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.common.internal.context.util.EPStatementDispatch;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementAgentInstancePreload;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityEvaluate;
import com.espertech.esper.common.internal.epl.expression.prior.PriorEvalStrategy;
import com.espertech.esper.common.internal.epl.join.base.JoinExecStrategyDispatchable;
import com.espertech.esper.common.internal.epl.join.base.JoinExecutionStrategyImpl;
import com.espertech.esper.common.internal.epl.join.base.JoinPreloadMethod;
import com.espertech.esper.common.internal.epl.join.base.JoinPreloadMethodImpl;
import com.espertech.esper.common.internal.epl.join.base.JoinPreloadMethodNull;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposer;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototype;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerView;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessView;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessViewFactoryProvider;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootMatchRemover;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootState;
import com.espertech.esper.common.internal.epl.prior.PriorHelper;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryProvider;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogHelper;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewFactory;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewService;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPreviousStrategy;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactory;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryResult;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperStart;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalHelperStart;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategy;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategyFactory;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateDesc;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.PatternRemoveDispatchView;
import com.espertech.esper.common.internal.view.core.SingleStreamDispatchView;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewFactoryUtil;
import com.espertech.esper.common.internal.view.core.Viewable;
import com.espertech.esper.common.internal.view.core.ViewablePair;
import com.espertech.esper.common.internal.view.filter.FilterExprView;
import com.espertech.esper.common.internal.view.previous.PreviousGetterStrategy;
import com.espertech.esper.common.internal.view.util.BufferView;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class StatementAgentInstanceFactorySelect
implements StatementAgentInstanceFactory {
    private String[] streamNames;
    private ViewableActivator[] viewableActivators;
    private ResultSetProcessorFactoryProvider resultSetProcessorFactoryProvider;
    private ViewFactory[][] viewFactories;
    private ExprEvaluator whereClauseEvaluator;
    private String whereClauseEvaluatorTextForAudit;
    private OutputProcessViewFactoryProvider outputProcessViewFactoryProvider;
    private ViewResourceDelegateDesc[] viewResourceDelegates;
    private JoinSetComposerPrototype joinSetComposerPrototype;
    private Map<Integer, SubSelectFactory> subselects;
    private Map<Integer, ExprTableEvalStrategyFactory> tableAccesses;
    private boolean orderByWithoutOutputRateLimit;
    private boolean unidirectionalJoin;

    public void setViewableActivators(ViewableActivator[] viewableActivators) {
        this.viewableActivators = viewableActivators;
    }

    public void setResultSetProcessorFactoryProvider(ResultSetProcessorFactoryProvider resultSetProcessorFactoryProvider) {
        this.resultSetProcessorFactoryProvider = resultSetProcessorFactoryProvider;
    }

    public void setViewFactories(ViewFactory[][] viewFactories) {
        this.viewFactories = viewFactories;
    }

    public void setOutputProcessViewFactoryProvider(OutputProcessViewFactoryProvider outputProcessViewFactoryProvider) {
        this.outputProcessViewFactoryProvider = outputProcessViewFactoryProvider;
    }

    public void setViewResourceDelegates(ViewResourceDelegateDesc[] viewResourceDelegates) {
        this.viewResourceDelegates = viewResourceDelegates;
    }

    public void setWhereClauseEvaluator(ExprEvaluator whereClauseEvaluator) {
        this.whereClauseEvaluator = whereClauseEvaluator;
    }

    public void setStreamNames(String[] streamNames) {
        this.streamNames = streamNames;
    }

    public void setJoinSetComposerPrototype(JoinSetComposerPrototype joinSetComposerPrototype) {
        this.joinSetComposerPrototype = joinSetComposerPrototype;
    }

    public void setSubselects(Map<Integer, SubSelectFactory> subselects) {
        this.subselects = subselects;
    }

    public void setOrderByWithoutOutputRateLimit(boolean orderByWithoutOutputRateLimit) {
        this.orderByWithoutOutputRateLimit = orderByWithoutOutputRateLimit;
    }

    public void setUnidirectionalJoin(boolean unidirectionalJoin) {
        this.unidirectionalJoin = unidirectionalJoin;
    }

    public void setTableAccesses(Map<Integer, ExprTableEvalStrategyFactory> tableAccesses) {
        this.tableAccesses = tableAccesses;
    }

    public void setWhereClauseEvaluatorTextForAudit(String whereClauseEvaluatorTextForAudit) {
        this.whereClauseEvaluatorTextForAudit = whereClauseEvaluatorTextForAudit;
    }

    @Override
    public void statementCreate(StatementContext statementContext) {
    }

    @Override
    public void statementDestroy(StatementContext statementContext) {
    }

    @Override
    public StatementAgentInstanceLock obtainAgentInstanceLock(StatementContext statementContext, int agentInstanceId) {
        return AgentInstanceUtil.newLock(statementContext);
    }

    @Override
    public StatementAgentInstanceFactorySelectResult newContext(AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        JoinPreloadMethod joinPreloadMethod;
        JoinSetComposer joinSetComposer;
        OutputProcessView outputProcessView;
        ArrayList<AgentInstanceStopCallback> stopCallbacks = new ArrayList<AgentInstanceStopCallback>();
        ArrayList<StatementAgentInstancePreload> preloadList = new ArrayList<StatementAgentInstancePreload>();
        int numStreams = this.viewableActivators.length;
        ViewableActivationResult[] activationResults = new ViewableActivationResult[numStreams];
        Viewable[] eventStreamParentViewable = new Viewable[numStreams];
        EvalRootState[] patternRoots = new EvalRootState[numStreams];
        EvalRootMatchRemover evalRootMatchRemover = null;
        boolean suppressSameEventMatches = false;
        boolean discardPartialsOnMatch = false;
        for (int stream = 0; stream < numStreams; ++stream) {
            ViewableActivationResult activationResult = this.viewableActivators[stream].activate(agentInstanceContext, false, isRecoveringResilient);
            stopCallbacks.add(activationResult.getStopCallback());
            activationResults[stream] = activationResult;
            eventStreamParentViewable[stream] = activationResult.getViewable();
            patternRoots[stream] = activationResult.getOptionalPatternRoot();
            suppressSameEventMatches = activationResult.isSuppressSameEventMatches();
            discardPartialsOnMatch = activationResult.isDiscardPartialsOnMatch();
            if (stream != 0) continue;
            evalRootMatchRemover = activationResult.getOptEvalRootMatchRemover();
        }
        AgentInstanceViewFactoryChainContext[] viewFactoryChainContexts = new AgentInstanceViewFactoryChainContext[numStreams];
        PriorEvalStrategy[] priorEvalStrategies = new PriorEvalStrategy[numStreams];
        PreviousGetterStrategy[] previousGetterStrategies = new PreviousGetterStrategy[numStreams];
        RowRecogPreviousStrategy rowRecogPreviousStrategy = null;
        for (int i = 0; i < numStreams; ++i) {
            viewFactoryChainContexts[i] = AgentInstanceViewFactoryChainContext.create(this.viewFactories[i], agentInstanceContext, this.viewResourceDelegates[i]);
            priorEvalStrategies[i] = PriorHelper.toStrategy(viewFactoryChainContexts[i]);
            previousGetterStrategies[i] = viewFactoryChainContexts[i].getPreviousNodeGetter();
        }
        Viewable[] topViews = new Viewable[numStreams];
        Viewable[] streamViews = new Viewable[numStreams];
        for (int stream = 0; stream < numStreams; ++stream) {
            ViewablePair viewables = ViewFactoryUtil.materialize(this.viewFactories[stream], eventStreamParentViewable[stream], viewFactoryChainContexts[stream], stopCallbacks);
            topViews[stream] = viewables.getTop();
            streamViews[stream] = viewables.getLast();
        }
        RowRecogNFAViewService matchRecognize = RowRecogHelper.recursiveFindRegexService(topViews[0]);
        if (matchRecognize != null) {
            rowRecogPreviousStrategy = matchRecognize.getPreviousEvaluationStrategy();
            stopCallbacks.add(matchRecognize);
        }
        Map<Integer, SubSelectFactoryResult> subselectActivations = SubSelectHelperStart.startSubselects(this.subselects, agentInstanceContext, stopCallbacks, isRecoveringResilient);
        Map<Integer, ExprTableEvalStrategy> tableAccessEvals = ExprTableEvalHelperStart.startTableAccess(this.tableAccesses, agentInstanceContext);
        final Pair<ResultSetProcessor, AggregationService> processorPair = StatementAgentInstanceFactoryUtil.startResultSetAndAggregation(this.resultSetProcessorFactoryProvider, agentInstanceContext, false, null);
        stopCallbacks.add(new AgentInstanceStopCallback(){

            @Override
            public void stop(AgentInstanceStopServices services) {
                ((ResultSetProcessor)processorPair.getFirst()).stop();
                ((AggregationService)processorPair.getSecond()).stop();
            }
        });
        if (streamViews.length == 1) {
            outputProcessView = this.handleSimpleSelect(streamViews, processorPair.getFirst(), evalRootMatchRemover, suppressSameEventMatches, discardPartialsOnMatch, agentInstanceContext);
            joinSetComposer = null;
            joinPreloadMethod = null;
        } else {
            JoinPlanResult joinPlanResult = this.handleJoin(streamViews, processorPair.getFirst(), agentInstanceContext, stopCallbacks, isRecoveringResilient);
            outputProcessView = joinPlanResult.getViewable();
            joinSetComposer = joinPlanResult.getJoinSetComposerDesc().getJoinSetComposer();
            joinPreloadMethod = joinPlanResult.getPreloadMethod();
        }
        stopCallbacks.add(outputProcessView);
        if (!isRecoveringResilient) {
            boolean aggregated = this.resultSetProcessorFactoryProvider.getResultSetProcessorType().isAggregated();
            this.handlePreloads(preloadList, aggregated, joinPreloadMethod, activationResults, agentInstanceContext, processorPair.getFirst());
        }
        AgentInstanceStopCallback stopCallback = AgentInstanceUtil.finalizeSafeStopCallbacks(stopCallbacks);
        return new StatementAgentInstanceFactorySelectResult(outputProcessView, stopCallback, agentInstanceContext, processorPair.getSecond(), subselectActivations, priorEvalStrategies, previousGetterStrategies, rowRecogPreviousStrategy, tableAccessEvals, preloadList, patternRoots, joinSetComposer, topViews, eventStreamParentViewable, activationResults, processorPair.getFirst());
    }

    @Override
    public EventType getStatementEventType() {
        return this.resultSetProcessorFactoryProvider.getResultEventType();
    }

    @Override
    public AIRegistryRequirements getRegistryRequirements() {
        boolean hasPrior = false;
        boolean hasPrevious = false;
        for (int i = 0; i < this.viewResourceDelegates.length; ++i) {
            if (this.viewResourceDelegates[i].getPriorRequests() != null && !this.viewResourceDelegates[i].getPriorRequests().isEmpty()) {
                hasPrior = true;
            }
            hasPrevious |= this.viewResourceDelegates[i].isHasPrevious();
        }
        boolean[] prior = null;
        if (hasPrior) {
            prior = new boolean[this.viewResourceDelegates.length];
            for (int i = 0; i < this.viewResourceDelegates.length; ++i) {
                if (this.viewResourceDelegates[i].getPriorRequests() == null || this.viewResourceDelegates[i].getPriorRequests().isEmpty()) continue;
                prior[i] = true;
            }
        }
        boolean[] previous = null;
        if (hasPrevious) {
            previous = new boolean[this.viewResourceDelegates.length];
            for (int i = 0; i < this.viewResourceDelegates.length; ++i) {
                previous[i] = this.viewResourceDelegates[i].isHasPrevious();
            }
        }
        AIRegistryRequirementSubquery[] subqueries = AIRegistryRequirements.getSubqueryRequirements(this.subselects);
        boolean hasRowRecogWithPrevious = false;
        for (ViewFactory viewFactory : this.viewFactories[0]) {
            if (!(viewFactory instanceof RowRecogNFAViewFactory)) continue;
            RowRecogNFAViewFactory recog = (RowRecogNFAViewFactory)viewFactory;
            hasRowRecogWithPrevious = recog.getDesc().getPreviousRandomAccessIndexes() != null;
        }
        return new AIRegistryRequirements(prior, previous, subqueries, this.tableAccesses == null ? 0 : this.tableAccesses.size(), hasRowRecogWithPrevious);
    }

    private OutputProcessView handleSimpleSelect(Viewable[] streamViews, ResultSetProcessor resultSetProcessor, EvalRootMatchRemover evalRootMatchRemover, boolean suppressSameEventMatches, boolean discardPartialsOnMatch, AgentInstanceContext agentInstanceContext) {
        ArrayDeque<SingleStreamDispatchView> dispatches = null;
        Viewable finalView = streamViews[0];
        if (this.whereClauseEvaluator != null) {
            FilterExprView filterView = new FilterExprView(this.whereClauseEvaluator, agentInstanceContext, this.whereClauseEvaluatorTextForAudit);
            finalView.setChild(filterView);
            filterView.setParent(finalView);
            finalView = filterView;
        }
        if (evalRootMatchRemover != null && (suppressSameEventMatches || discardPartialsOnMatch)) {
            PatternRemoveDispatchView v = new PatternRemoveDispatchView(evalRootMatchRemover, suppressSameEventMatches, discardPartialsOnMatch);
            dispatches = new ArrayDeque<SingleStreamDispatchView>(2);
            dispatches.add((SingleStreamDispatchView)((Object)v));
            finalView.setChild(v);
            v.setParent(finalView);
            finalView = v;
        }
        if (this.orderByWithoutOutputRateLimit) {
            SingleStreamDispatchView bf = new SingleStreamDispatchView();
            if (dispatches == null) {
                dispatches = new ArrayDeque(1);
            }
            dispatches.add(bf);
            finalView.setChild(bf);
            bf.setParent(finalView);
            finalView = bf;
        }
        if (dispatches != null) {
            EPStatementAgentInstanceHandle handle = agentInstanceContext.getEpStatementAgentInstanceHandle();
            if (dispatches.size() == 1) {
                handle.setOptionalDispatchable((EPStatementDispatch)dispatches.getFirst());
            } else {
                final EPStatementDispatch[] dispatchArray = dispatches.toArray(new EPStatementDispatch[dispatches.size()]);
                handle.setOptionalDispatchable(new EPStatementDispatch(){

                    @Override
                    public void execute() {
                        for (EPStatementDispatch dispatch : dispatchArray) {
                            dispatch.execute();
                        }
                    }
                });
            }
        }
        OutputProcessView outputProcessView = this.outputProcessViewFactoryProvider.getOutputProcessViewFactory().makeView(resultSetProcessor, agentInstanceContext);
        finalView.setChild(outputProcessView);
        outputProcessView.setParent(finalView);
        return outputProcessView;
    }

    private JoinPlanResult handleJoin(Viewable[] streamViews, ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext, List<AgentInstanceStopCallback> stopCallbacks, boolean isRecoveringResilient) {
        final JoinSetComposerDesc joinSetComposerDesc = this.joinSetComposerPrototype.create(streamViews, false, agentInstanceContext, isRecoveringResilient);
        stopCallbacks.add(new AgentInstanceStopCallback(){

            @Override
            public void stop(AgentInstanceStopServices services) {
                joinSetComposerDesc.getJoinSetComposer().destroy();
            }
        });
        OutputProcessView outputProcessView = this.outputProcessViewFactoryProvider.getOutputProcessViewFactory().makeView(resultSetProcessor, agentInstanceContext);
        JoinExecutionStrategyImpl execution = new JoinExecutionStrategyImpl(joinSetComposerDesc.getJoinSetComposer(), joinSetComposerDesc.getPostJoinFilterEvaluator(), outputProcessView, agentInstanceContext);
        outputProcessView.setJoinExecutionStrategy(execution);
        JoinExecStrategyDispatchable joinStatementDispatch = new JoinExecStrategyDispatchable(execution, streamViews.length, agentInstanceContext);
        agentInstanceContext.getEpStatementAgentInstanceHandle().setOptionalDispatchable(joinStatementDispatch);
        JoinPreloadMethod preloadMethod = this.unidirectionalJoin || !joinSetComposerDesc.getJoinSetComposer().allowsInit() ? new JoinPreloadMethodNull() : new JoinPreloadMethodImpl(this.streamNames.length, joinSetComposerDesc.getJoinSetComposer());
        for (int i = 0; i < streamViews.length; ++i) {
            BufferView buffer = new BufferView(i);
            streamViews[i].setChild(buffer);
            buffer.setObserver(joinStatementDispatch);
            preloadMethod.setBuffer(buffer, i);
        }
        return new JoinPlanResult(outputProcessView, preloadMethod, joinSetComposerDesc);
    }

    private void handlePreloads(List<StatementAgentInstancePreload> preloadList, boolean isAggregated, JoinPreloadMethod joinPreloadMethod, ViewableActivationResult[] activationResults, AgentInstanceContext agentInstanceContext, ResultSetProcessor resultSetProcessor) {
        boolean hasNamedWindow = false;
        for (int stream = 0; stream < activationResults.length; ++stream) {
            ViewableActivationResult activationResult = activationResults[stream];
            if (!(activationResult.getViewable() instanceof NamedWindowConsumerView)) continue;
            hasNamedWindow = true;
            NamedWindowConsumerView consumer = (NamedWindowConsumerView)activationResult.getViewable();
            if (consumer.getConsumerCallback().isParentBatchWindow()) continue;
            ViewableActivatorNamedWindow nwActivator = (ViewableActivatorNamedWindow)this.viewableActivators[stream];
            preloadList.add(new NamedWindowConsumerPreload(nwActivator, consumer, agentInstanceContext, joinPreloadMethod));
            if (this.streamNames.length == 1) {
                preloadList.add(new NamedWindowConsumerPreloadDispatchNonJoin(agentInstanceContext));
                continue;
            }
            preloadList.add(new NamedWindowConsumerPreloadDispatchJoin(joinPreloadMethod, stream, agentInstanceContext));
        }
        if (hasNamedWindow && joinPreloadMethod != null && isAggregated) {
            preloadList.add(new NamedWindowConsumerPreloadAggregationJoin(joinPreloadMethod, resultSetProcessor));
        }
    }

    private static class NamedWindowConsumerPreloadAggregationJoin
    implements StatementAgentInstancePreload {
        private final JoinPreloadMethod joinPreloadMethod;
        private final ResultSetProcessor resultSetProcessor;

        public NamedWindowConsumerPreloadAggregationJoin(JoinPreloadMethod joinPreloadMethod, ResultSetProcessor resultSetProcessor) {
            this.joinPreloadMethod = joinPreloadMethod;
            this.resultSetProcessor = resultSetProcessor;
        }

        @Override
        public void executePreload() {
            this.joinPreloadMethod.preloadAggregation(this.resultSetProcessor);
        }
    }

    private static class NamedWindowConsumerPreloadDispatchJoin
    implements StatementAgentInstancePreload {
        private final JoinPreloadMethod joinPreloadMethod;
        private final int stream;
        private final AgentInstanceContext agentInstanceContext;

        public NamedWindowConsumerPreloadDispatchJoin(JoinPreloadMethod joinPreloadMethod, int stream, AgentInstanceContext agentInstanceContext) {
            this.joinPreloadMethod = joinPreloadMethod;
            this.stream = stream;
            this.agentInstanceContext = agentInstanceContext;
        }

        @Override
        public void executePreload() {
            this.joinPreloadMethod.preloadFromBuffer(this.stream, this.agentInstanceContext);
        }
    }

    private static class NamedWindowConsumerPreloadDispatchNonJoin
    implements StatementAgentInstancePreload {
        private final AgentInstanceContext agentInstanceContext;

        public NamedWindowConsumerPreloadDispatchNonJoin(AgentInstanceContext agentInstanceContext) {
            this.agentInstanceContext = agentInstanceContext;
        }

        @Override
        public void executePreload() {
            if (this.agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable() != null) {
                this.agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable().execute();
            }
        }
    }

    private static class NamedWindowConsumerPreload
    implements StatementAgentInstancePreload {
        private final ViewableActivatorNamedWindow nwActivator;
        private final NamedWindowConsumerView consumer;
        private final AgentInstanceContext agentInstanceContext;
        private final JoinPreloadMethod joinPreloadMethod;

        public NamedWindowConsumerPreload(ViewableActivatorNamedWindow nwActivator, NamedWindowConsumerView consumer, AgentInstanceContext agentInstanceContext, JoinPreloadMethod joinPreloadMethod) {
            this.nwActivator = nwActivator;
            this.consumer = consumer;
            this.agentInstanceContext = agentInstanceContext;
            this.joinPreloadMethod = joinPreloadMethod;
        }

        @Override
        public void executePreload() {
            EventBean[] events;
            if (this.nwActivator.getNamedWindowContextName() != null && !this.nwActivator.getNamedWindowContextName().equals(this.agentInstanceContext.getStatementContext().getContextName())) {
                return;
            }
            Collection<EventBean> snapshot = this.consumer.getConsumerCallback().snapshot(this.nwActivator.getFilterQueryGraph(), this.agentInstanceContext.getAnnotations());
            if (this.consumer.getFilter() == null) {
                events = CollectionUtil.toArrayEvents(snapshot);
            } else {
                ArrayList<EventBean> eventsInWindow = new ArrayList<EventBean>(snapshot.size());
                ExprNodeUtilityEvaluate.applyFilterExpressionIterable(snapshot.iterator(), this.consumer.getFilter(), this.agentInstanceContext, eventsInWindow);
                events = eventsInWindow.toArray(new EventBean[eventsInWindow.size()]);
            }
            if (events.length == 0) {
                return;
            }
            this.consumer.update(events, null);
            if (this.joinPreloadMethod != null && !this.joinPreloadMethod.isPreloading() && this.agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable() != null) {
                this.agentInstanceContext.getEpStatementAgentInstanceHandle().getOptionalDispatchable().execute();
            }
        }
    }

    private static class JoinPlanResult {
        private final OutputProcessView outputProcessView;
        private final JoinPreloadMethod preloadMethod;
        private final JoinSetComposerDesc joinSetComposerDesc;

        private JoinPlanResult(OutputProcessView viewable, JoinPreloadMethod preloadMethod, JoinSetComposerDesc joinSetComposerDesc) {
            this.outputProcessView = viewable;
            this.preloadMethod = preloadMethod;
            this.joinSetComposerDesc = joinSetComposerDesc;
        }

        public OutputProcessView getViewable() {
            return this.outputProcessView;
        }

        public JoinPreloadMethod getPreloadMethod() {
            return this.preloadMethod;
        }

        public JoinSetComposerDesc getJoinSetComposerDesc() {
            return this.joinSetComposerDesc;
        }
    }
}

