/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.airegistry;

import com.espertech.esper.common.internal.collection.ArrayWrap;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryAggregation;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryFactory;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryPreviousGetterStrategy;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryPriorEvalStrategy;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirementSubquery;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRowRecogPreviousStrategy;
import com.espertech.esper.common.internal.context.airegistry.AIRegistrySubqueryEntry;
import com.espertech.esper.common.internal.context.airegistry.AIRegistrySubselectLookup;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryTableAccess;
import com.espertech.esper.common.internal.context.airegistry.StatementAIResourceRegistry;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.expression.prior.PriorEvalStrategy;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPreviousStrategy;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryResult;
import com.espertech.esper.common.internal.epl.table.strategy.ExprTableEvalStrategy;
import com.espertech.esper.common.internal.view.previous.PreviousGetterStrategy;
import java.util.HashMap;
import java.util.Map;

public class AIRegistryUtil {
    public static StatementAIResourceRegistry allocateRegistries(AIRegistryRequirements registryRequirements, AIRegistryFactory factory) {
        int i;
        AIRegistryPriorEvalStrategy[] priorEvalStrategies = null;
        if (registryRequirements.getPriorFlagsPerStream() != null) {
            boolean[] priorFlagPerStream = registryRequirements.getPriorFlagsPerStream();
            priorEvalStrategies = new AIRegistryPriorEvalStrategy[priorFlagPerStream.length];
            for (int i2 = 0; i2 < priorEvalStrategies.length; ++i2) {
                if (!priorFlagPerStream[i2]) continue;
                priorEvalStrategies[i2] = factory.makePrior();
            }
        }
        AIRegistryPreviousGetterStrategy[] previousGetterStrategies = null;
        if (registryRequirements.getPreviousFlagsPerStream() != null) {
            boolean[] previousFlagPerStream = registryRequirements.getPreviousFlagsPerStream();
            previousGetterStrategies = new AIRegistryPreviousGetterStrategy[previousFlagPerStream.length];
            for (int i3 = 0; i3 < previousGetterStrategies.length; ++i3) {
                if (!previousFlagPerStream[i3]) continue;
                previousGetterStrategies[i3] = factory.makePrevious();
            }
        }
        HashMap<Integer, AIRegistrySubqueryEntry> subselects = null;
        if (registryRequirements.getSubqueries() != null) {
            AIRegistryRequirementSubquery[] requirements = registryRequirements.getSubqueries();
            subselects = new HashMap<Integer, AIRegistrySubqueryEntry>();
            for (i = 0; i < requirements.length; ++i) {
                AIRegistrySubselectLookup lookup = factory.makeSubqueryLookup(requirements[i].getLookupStrategyDesc());
                AIRegistryAggregation aggregation = requirements[i].isHasAggregation() ? factory.makeAggregation() : null;
                AIRegistryPriorEvalStrategy prior = requirements[i].isHasPrior() ? factory.makePrior() : null;
                AIRegistryPreviousGetterStrategy prev = requirements[i].isHasPrev() ? factory.makePrevious() : null;
                subselects.put(i, new AIRegistrySubqueryEntry(lookup, aggregation, prior, prev));
            }
        }
        HashMap<Integer, AIRegistryTableAccess> tableAccesses = null;
        if (registryRequirements.getTableAccessCount() > 0) {
            tableAccesses = new HashMap<Integer, AIRegistryTableAccess>();
            for (i = 0; i < registryRequirements.getTableAccessCount(); ++i) {
                AIRegistryTableAccess strategy = factory.makeTableAccess();
                tableAccesses.put(i, strategy);
            }
        }
        AIRegistryRowRecogPreviousStrategy rowRecogPreviousStrategy = null;
        if (registryRequirements.isRowRecogWithPrevious()) {
            rowRecogPreviousStrategy = factory.makeRowRecogPreviousStrategy();
        }
        return new StatementAIResourceRegistry(factory.makeAggregation(), priorEvalStrategies, subselects, tableAccesses, previousGetterStrategies, rowRecogPreviousStrategy);
    }

    public static void assignFutures(StatementAIResourceRegistry aiResourceRegistry, int agentInstanceId, AggregationService optionalAggegationService, PriorEvalStrategy[] optionalPriorStrategies, PreviousGetterStrategy[] optionalPreviousGetters, Map<Integer, SubSelectFactoryResult> subselects, Map<Integer, ExprTableEvalStrategy> tableAccessStrategies, RowRecogPreviousStrategy rowRecogPreviousStrategy) {
        Object registryEntry;
        int i;
        if (optionalAggegationService != null) {
            aiResourceRegistry.getAgentInstanceAggregationService().assignService(agentInstanceId, optionalAggegationService);
        }
        if (optionalPriorStrategies != null) {
            for (i = 0; i < optionalPriorStrategies.length; ++i) {
                if (optionalPriorStrategies[i] == null) continue;
                aiResourceRegistry.getAgentInstancePriorEvalStrategies()[i].assignService(agentInstanceId, optionalPriorStrategies[i]);
            }
        }
        if (optionalPreviousGetters != null) {
            for (i = 0; i < optionalPreviousGetters.length; ++i) {
                if (optionalPreviousGetters[i] == null) continue;
                aiResourceRegistry.getAgentInstancePreviousGetterStrategies()[i].assignService(agentInstanceId, optionalPreviousGetters[i]);
            }
        }
        for (Map.Entry<Integer, SubSelectFactoryResult> entry : subselects.entrySet()) {
            registryEntry = aiResourceRegistry.getAgentInstanceSubselects().get(entry.getKey());
            SubSelectFactoryResult subq = entry.getValue();
            ((AIRegistrySubqueryEntry)registryEntry).assign(agentInstanceId, subq.getLookupStrategy(), subq.getAggregationService(), subq.getPriorStrategy(), subq.getPreviousStrategy());
        }
        for (Map.Entry<Integer, Object> entry : tableAccessStrategies.entrySet()) {
            registryEntry = aiResourceRegistry.getAgentInstanceTableAccesses().get(entry.getKey());
            ExprTableEvalStrategy evalStrategy = (ExprTableEvalStrategy)entry.getValue();
            registryEntry.assignService(agentInstanceId, evalStrategy);
        }
        if (rowRecogPreviousStrategy != null) {
            aiResourceRegistry.getAgentInstanceRowRecogPreviousStrategy().assignService(agentInstanceId, rowRecogPreviousStrategy);
        }
    }

    public static void checkExpand(int serviceId, ArrayWrap services) {
        if (serviceId > services.getArray().length - 1) {
            int delta = serviceId - services.getArray().length + 1;
            services.expand(delta);
        }
    }
}

