/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.airegistry;

import com.espertech.esper.common.internal.context.airegistry.AIRegistryAggregation;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryPreviousGetterStrategy;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryPriorEvalStrategy;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRowRecogPreviousStrategy;
import com.espertech.esper.common.internal.context.airegistry.AIRegistrySubqueryEntry;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryTableAccess;
import java.util.Map;

public class StatementAIResourceRegistry {
    private final AIRegistryAggregation agentInstanceAggregationService;
    private final AIRegistryPriorEvalStrategy[] agentInstancePriorEvalStrategies;
    private final Map<Integer, AIRegistrySubqueryEntry> agentInstanceSubselects;
    private final Map<Integer, AIRegistryTableAccess> agentInstanceTableAccesses;
    private final AIRegistryPreviousGetterStrategy[] agentInstancePreviousGetterStrategies;
    private final AIRegistryRowRecogPreviousStrategy agentInstanceRowRecogPreviousStrategy;

    public StatementAIResourceRegistry(AIRegistryAggregation agentInstanceAggregationService, AIRegistryPriorEvalStrategy[] agentInstancePriorEvalStrategies, Map<Integer, AIRegistrySubqueryEntry> agentInstanceSubselects, Map<Integer, AIRegistryTableAccess> agentInstanceTableAccesses, AIRegistryPreviousGetterStrategy[] agentInstancePreviousGetterStrategies, AIRegistryRowRecogPreviousStrategy agentInstanceRowRecogPreviousStrategy) {
        this.agentInstanceAggregationService = agentInstanceAggregationService;
        this.agentInstancePriorEvalStrategies = agentInstancePriorEvalStrategies;
        this.agentInstanceSubselects = agentInstanceSubselects;
        this.agentInstanceTableAccesses = agentInstanceTableAccesses;
        this.agentInstancePreviousGetterStrategies = agentInstancePreviousGetterStrategies;
        this.agentInstanceRowRecogPreviousStrategy = agentInstanceRowRecogPreviousStrategy;
    }

    public AIRegistryAggregation getAgentInstanceAggregationService() {
        return this.agentInstanceAggregationService;
    }

    public AIRegistryPriorEvalStrategy[] getAgentInstancePriorEvalStrategies() {
        return this.agentInstancePriorEvalStrategies;
    }

    public AIRegistryPreviousGetterStrategy[] getAgentInstancePreviousGetterStrategies() {
        return this.agentInstancePreviousGetterStrategies;
    }

    public Map<Integer, AIRegistrySubqueryEntry> getAgentInstanceSubselects() {
        return this.agentInstanceSubselects;
    }

    public Map<Integer, AIRegistryTableAccess> getAgentInstanceTableAccesses() {
        return this.agentInstanceTableAccesses;
    }

    public AIRegistryRowRecogPreviousStrategy getAgentInstanceRowRecogPreviousStrategy() {
        return this.agentInstanceRowRecogPreviousStrategy;
    }

    public void deassign(int agentInstanceId) {
        this.agentInstanceAggregationService.deassignService(agentInstanceId);
        if (this.agentInstancePriorEvalStrategies != null) {
            for (AIRegistryPriorEvalStrategy prior : this.agentInstancePriorEvalStrategies) {
                prior.deassignService(agentInstanceId);
            }
        }
        if (this.agentInstanceSubselects != null) {
            for (Map.Entry entry : this.agentInstanceSubselects.entrySet()) {
                ((AIRegistrySubqueryEntry)entry.getValue()).deassignService(agentInstanceId);
            }
        }
        if (this.agentInstancePreviousGetterStrategies != null) {
            for (AIRegistryPreviousGetterStrategy previous : this.agentInstancePreviousGetterStrategies) {
                previous.deassignService(agentInstanceId);
            }
        }
        if (this.agentInstanceTableAccesses != null) {
            for (Map.Entry entry : this.agentInstanceTableAccesses.entrySet()) {
                ((AIRegistryTableAccess)entry.getValue()).deassignService(agentInstanceId);
            }
        }
    }
}

