/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.compile;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerPortableInfo;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;

public class ContextMetaData {
    private final String contextName;
    private final String contextModuleName;
    private final NameAccessModifier contextVisibility;
    private final EventType eventType;
    private final ContextControllerPortableInfo[] validationInfos;

    public ContextMetaData(String contextName, String contextModuleName, NameAccessModifier contextVisibility, EventType eventType, ContextControllerPortableInfo[] validationInfos) {
        this.contextName = contextName;
        this.contextModuleName = contextModuleName;
        this.contextVisibility = contextVisibility;
        this.eventType = eventType;
        this.validationInfos = validationInfos;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public ContextControllerPortableInfo[] getValidationInfos() {
        return this.validationInfos;
    }

    public String getContextName() {
        return this.contextName;
    }

    public String getContextModuleName() {
        return this.contextModuleName;
    }

    public NameAccessModifier getContextVisibility() {
        return this.contextVisibility;
    }

    public CodegenExpression make(CodegenExpressionRef addInitSvc) {
        CodegenExpression[] validationInfos = new CodegenExpression[this.validationInfos.length];
        for (int i = 0; i < validationInfos.length; ++i) {
            validationInfos[i] = this.validationInfos[i].make(addInitSvc);
        }
        return CodegenExpressionBuilder.newInstance(ContextMetaData.class, CodegenExpressionBuilder.constant(this.contextName), CodegenExpressionBuilder.constant(this.contextModuleName), CodegenExpressionBuilder.constant((Object)this.contextVisibility), EventTypeUtility.resolveTypeCodegen(this.eventType, addInitSvc), CodegenExpressionBuilder.newArrayWithInit(ContextControllerPortableInfo.class, validationInfos));
    }
}

