/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.condition;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptor;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorFilter;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionCallback;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerEndConditionMatchEventProvider;
import com.espertech.esper.common.internal.context.controller.core.ContextController;
import com.espertech.esper.common.internal.context.mgr.ContextManagerUtil;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackFilter;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filtersvc.FilterHandleCallback;
import java.util.Collection;

public class ContextControllerConditionFilter
implements ContextControllerConditionNonHA {
    private final IntSeqKey conditionPath;
    private final Object[] partitionKeys;
    private final ContextConditionDescriptorFilter filter;
    private final ContextControllerConditionCallback callback;
    private final ContextController controller;
    private EPStatementHandleCallbackFilter filterHandle;
    private EventBean lastEvent;

    public ContextControllerConditionFilter(IntSeqKey conditionPath, Object[] partitionKeys, ContextConditionDescriptorFilter filter, ContextControllerConditionCallback callback, ContextController controller) {
        this.conditionPath = conditionPath;
        this.partitionKeys = partitionKeys;
        this.filter = filter;
        this.callback = callback;
        this.controller = controller;
    }

    @Override
    public boolean activate(EventBean optionalTriggeringEvent, ContextControllerEndConditionMatchEventProvider endConditionMatchEventProvider) {
        AgentInstanceContext agentInstanceContext = this.controller.getRealization().getAgentInstanceContextCreate();
        FilterHandleCallback filterCallback = new FilterHandleCallback(){

            @Override
            public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
                ContextControllerConditionFilter.this.filterMatchFound(theEvent);
            }

            @Override
            public boolean isSubSelect() {
                return false;
            }
        };
        FilterValueSetParam[][] addendum = ContextManagerUtil.computeAddendumNonStmt(this.partitionKeys, this.filter.getFilterSpecActivatable(), this.controller.getRealization());
        this.filterHandle = new EPStatementHandleCallbackFilter(agentInstanceContext.getEpStatementAgentInstanceHandle(), filterCallback);
        FilterValueSetParam[][] filterValueSet = this.filter.getFilterSpecActivatable().getValueSet(null, addendum, agentInstanceContext, agentInstanceContext.getStatementContextFilterEvalEnv());
        agentInstanceContext.getFilterService().add(this.filter.getFilterSpecActivatable().getFilterForEventType(), filterValueSet, this.filterHandle);
        long filtersVersion = agentInstanceContext.getFilterService().getFiltersVersion();
        agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
        boolean match = false;
        if (optionalTriggeringEvent != null) {
            match = AgentInstanceUtil.evaluateFilterForStatement(optionalTriggeringEvent, agentInstanceContext, this.filterHandle);
        }
        return match;
    }

    @Override
    public void deactivate() {
        if (this.filterHandle == null) {
            return;
        }
        AgentInstanceContext agentInstanceContext = this.controller.getRealization().getAgentInstanceContextCreate();
        FilterValueSetParam[][] addendum = ContextManagerUtil.computeAddendumNonStmt(this.partitionKeys, this.filter.getFilterSpecActivatable(), this.controller.getRealization());
        FilterValueSetParam[][] filterValueSet = this.filter.getFilterSpecActivatable().getValueSet(null, addendum, agentInstanceContext, agentInstanceContext.getStatementContextFilterEvalEnv());
        agentInstanceContext.getFilterService().remove(this.filterHandle, this.filter.getFilterSpecActivatable().getFilterForEventType(), filterValueSet);
        this.filterHandle = null;
        long filtersVersion = agentInstanceContext.getStatementContext().getFilterService().getFiltersVersion();
        agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public boolean isRunning() {
        return this.filterHandle != null;
    }

    @Override
    public ContextConditionDescriptor getDescriptor() {
        return this.filter;
    }

    @Override
    public Long getExpectedEndTime() {
        return null;
    }

    private void filterMatchFound(EventBean theEvent) {
        if (this.filter.getFilterSpecActivatable().getParameters().length > 1) {
            if (theEvent == this.lastEvent) {
                return;
            }
            this.lastEvent = theEvent;
        }
        this.callback.rangeNotification(this.conditionPath, this, theEvent, null, null, null);
    }
}

