/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.condition;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptor;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorTimePeriod;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionCallback;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerEndConditionMatchEventProvider;
import com.espertech.esper.common.internal.context.controller.core.ContextController;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;

public class ContextControllerConditionTimePeriod
implements ContextControllerConditionNonHA {
    public static final String NAME_AUDITPROVIDER_SCHEDULE = "context-condition time-period";
    private final long scheduleSlot;
    private final ContextConditionDescriptorTimePeriod timePeriod;
    private final IntSeqKey conditionPath;
    private final ContextControllerConditionCallback callback;
    private final ContextController controller;
    private EPStatementHandleCallbackSchedule scheduleHandle;

    public ContextControllerConditionTimePeriod(long scheduleSlot, ContextConditionDescriptorTimePeriod timePeriod, IntSeqKey conditionPath, ContextControllerConditionCallback callback, ContextController controller) {
        this.scheduleSlot = scheduleSlot;
        this.timePeriod = timePeriod;
        this.conditionPath = conditionPath;
        this.callback = callback;
        this.controller = controller;
    }

    @Override
    public boolean activate(EventBean optionalTriggeringEvent, ContextControllerEndConditionMatchEventProvider endConditionMatchEventProvider) {
        ScheduleHandleCallback scheduleCallback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                AgentInstanceContext agentInstanceContext = ContextControllerConditionTimePeriod.this.controller.getRealization().getAgentInstanceContextCreate();
                agentInstanceContext.getInstrumentationProvider().qContextScheduledEval(agentInstanceContext.getStatementContext().getContextRuntimeDescriptor());
                ContextControllerConditionTimePeriod.this.scheduleHandle = null;
                agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext, ScheduleObjectType.context, ContextControllerConditionTimePeriod.NAME_AUDITPROVIDER_SCHEDULE);
                ContextControllerConditionTimePeriod.this.callback.rangeNotification(ContextControllerConditionTimePeriod.this.conditionPath, ContextControllerConditionTimePeriod.this, null, null, null, null);
                agentInstanceContext.getInstrumentationProvider().aContextScheduledEval();
            }
        };
        AgentInstanceContext agentInstanceContext = this.controller.getRealization().getAgentInstanceContextCreate();
        this.scheduleHandle = new EPStatementHandleCallbackSchedule(agentInstanceContext.getEpStatementAgentInstanceHandle(), scheduleCallback);
        long timeDelta = this.timePeriod.getTimePeriodCompute().deltaUseRuntimeTime(null, agentInstanceContext, agentInstanceContext.getTimeProvider());
        agentInstanceContext.getAuditProvider().scheduleAdd(timeDelta, agentInstanceContext, this.scheduleHandle, ScheduleObjectType.context, NAME_AUDITPROVIDER_SCHEDULE);
        agentInstanceContext.getSchedulingService().add(timeDelta, this.scheduleHandle, this.scheduleSlot);
        return false;
    }

    @Override
    public void deactivate() {
        if (this.scheduleHandle != null) {
            AgentInstanceContext agentInstanceContext = this.controller.getRealization().getAgentInstanceContextCreate();
            agentInstanceContext.getAuditProvider().scheduleRemove(agentInstanceContext, this.scheduleHandle, ScheduleObjectType.context, NAME_AUDITPROVIDER_SCHEDULE);
            agentInstanceContext.getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
        }
        this.scheduleHandle = null;
    }

    @Override
    public boolean isImmediate() {
        return this.timePeriod.isImmediate();
    }

    @Override
    public boolean isRunning() {
        return this.scheduleHandle != null;
    }

    @Override
    public Long getExpectedEndTime() {
        return this.timePeriod.getExpectedEndTime(this.controller.getRealization());
    }

    @Override
    public ContextConditionDescriptor getDescriptor() {
        return this.timePeriod;
    }
}

