/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.hash;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFilterEntry;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashSvc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;

public class ContextControllerHashSvcLevelAny
implements ContextControllerHashSvc {
    private final Map<IntSeqKey, MgmtInfo> mgmt = new HashMap<IntSeqKey, MgmtInfo>();
    private Map<IntSeqKey, Integer> optionalHashes;

    ContextControllerHashSvcLevelAny(boolean preallocate) {
        if (!preallocate) {
            this.optionalHashes = new HashMap<IntSeqKey, Integer>();
        }
    }

    @Override
    public void mgmtCreate(IntSeqKey controllerPath, Object[] parentPartitionKeys) {
        this.mgmt.put(controllerPath, new MgmtInfo(null, parentPartitionKeys));
    }

    @Override
    public int[] mgmtGetSubpathOrCPIdsWhenPreallocate(IntSeqKey path) {
        return this.mgmt.get(path).getSubpathOrCPIdsPreallocate();
    }

    @Override
    public void mgmtSetSubpathOrCPIdsWhenPreallocate(IntSeqKey path, int[] subpathOrCPIds) {
        this.mgmt.get(path).setSubpathOrCPIdsPreallocate(subpathOrCPIds);
    }

    @Override
    public void mgmtSetFilters(IntSeqKey controllerPath, ContextControllerFilterEntry[] filterEntries) {
        this.mgmt.get(controllerPath).setFilterEntries(filterEntries);
    }

    @Override
    public Object[] mgmtGetParentPartitionKeys(IntSeqKey controllerPath) {
        return this.mgmt.get(controllerPath).getParentPartitionKeys();
    }

    @Override
    public ContextControllerFilterEntry[] mgmtGetFilters(IntSeqKey controllerPath) {
        return this.mgmt.get(controllerPath).getFilterEntries();
    }

    @Override
    public boolean hashHasSeenPartition(IntSeqKey controllerPath, int value) {
        return this.optionalHashes.containsKey(controllerPath.addToEnd(value));
    }

    @Override
    public void hashAddPartition(IntSeqKey controllerPath, int value, int subpathIdOrCPId) {
        this.optionalHashes.put(controllerPath.addToEnd(value), subpathIdOrCPId);
    }

    @Override
    public void hashVisit(IntSeqKey controllerPath, BiConsumer<Integer, Integer> hashAndCPId) {
        if (this.optionalHashes == null) {
            MgmtInfo mgmtInfo = this.mgmt.get(controllerPath);
            if (mgmtInfo == null || mgmtInfo.getSubpathOrCPIdsPreallocate() == null) {
                return;
            }
            int[] subpathOrCPIds = mgmtInfo.getSubpathOrCPIdsPreallocate();
            for (int i = 0; i < subpathOrCPIds.length; ++i) {
                hashAndCPId.accept(i, subpathOrCPIds[i]);
            }
            return;
        }
        for (Map.Entry<IntSeqKey, Integer> entry : this.optionalHashes.entrySet()) {
            if (!controllerPath.isParentTo(entry.getKey())) continue;
            hashAndCPId.accept(entry.getKey().last(), entry.getValue());
        }
    }

    @Override
    public int hashGetSubpathOrCPId(IntSeqKey controllerPath, int hash) {
        if (this.optionalHashes == null) {
            MgmtInfo mgmtInfo = this.mgmt.get(controllerPath);
            return mgmtInfo.getSubpathOrCPIdsPreallocate()[hash];
        }
        Integer found = this.optionalHashes.get(controllerPath.addToEnd(hash));
        return found == null ? -1 : found;
    }

    @Override
    public Collection<Integer> deactivate(IntSeqKey controllerPath) {
        MgmtInfo mgmtInfo = this.mgmt.remove(controllerPath);
        if (this.optionalHashes == null) {
            return this.mgmtInfoToIds(mgmtInfo);
        }
        Iterator<Map.Entry<IntSeqKey, Integer>> it = this.optionalHashes.entrySet().iterator();
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (it.hasNext()) {
            Map.Entry<IntSeqKey, Integer> entry = it.next();
            if (!controllerPath.isParentTo(entry.getKey())) continue;
            result.add(entry.getValue());
            it.remove();
        }
        return result;
    }

    @Override
    public void destroy() {
        this.mgmt.clear();
        if (this.optionalHashes != null) {
            this.optionalHashes.clear();
        }
    }

    private Collection<Integer> mgmtInfoToIds(MgmtInfo mgmtInfo) {
        int[] subpathOrCPIdsPreallocate = mgmtInfo.getSubpathOrCPIdsPreallocate();
        ArrayList<Integer> ids = new ArrayList<Integer>(subpathOrCPIdsPreallocate.length);
        for (int id : subpathOrCPIdsPreallocate) {
            ids.add(id);
        }
        return ids;
    }

    private static class MgmtInfo {
        private ContextControllerFilterEntry[] filterEntries;
        private Object[] parentPartitionKeys;
        private int[] subpathOrCPIdsPreallocate;

        MgmtInfo(ContextControllerFilterEntry[] filterEntries, Object[] parentPartitionKeys) {
            this.filterEntries = filterEntries;
            this.parentPartitionKeys = parentPartitionKeys;
        }

        ContextControllerFilterEntry[] getFilterEntries() {
            return this.filterEntries;
        }

        public Object[] getParentPartitionKeys() {
            return this.parentPartitionKeys;
        }

        void setFilterEntries(ContextControllerFilterEntry[] filterEntries) {
            this.filterEntries = filterEntries;
        }

        int[] getSubpathOrCPIdsPreallocate() {
            return this.subpathOrCPIdsPreallocate;
        }

        void setSubpathOrCPIdsPreallocate(int[] subpathOrCPIdsPreallocate) {
            this.subpathOrCPIdsPreallocate = subpathOrCPIdsPreallocate;
        }
    }
}

