/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.hash;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.event.core.EventPropertyValueGetterForge;
import com.espertech.esper.common.internal.util.Serializer;
import com.espertech.esper.common.internal.util.SerializerFactory;
import java.io.IOException;
import java.util.List;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextControllerHashedGetterCRC32SerializedForge
implements EventPropertyValueGetterForge {
    private static final Logger log = LoggerFactory.getLogger(ContextControllerHashedGetterCRC32SerializedForge.class);
    private final ExprNode[] nodes;
    private final int granularity;

    public ContextControllerHashedGetterCRC32SerializedForge(List<ExprNode> nodes, int granularity) {
        this.nodes = nodes.toArray(new ExprNode[nodes.size()]);
        this.granularity = granularity;
    }

    public static int serializeAndCRC32Hash(Object objectMayArray, int granularity, Serializer[] serializers) {
        byte[] bytes;
        try {
            bytes = objectMayArray instanceof Object[] ? SerializerFactory.serialize(serializers, (Object[])objectMayArray) : SerializerFactory.serialize(serializers[0], objectMayArray);
        }
        catch (IOException e) {
            log.error("Exception serializing parameters for computing consistent hash: " + e.getMessage(), (Throwable)e);
            bytes = new byte[]{};
        }
        CRC32 crc = new CRC32();
        crc.update(bytes);
        long value = crc.getValue() % (long)granularity;
        int result = (int)value;
        if (result >= 0) {
            return result;
        }
        return -result;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope parent, CodegenClassScope classScope) {
        int i;
        CodegenExpressionField serializers = classScope.addFieldUnshared(true, Serializer[].class, CodegenExpressionBuilder.staticMethod(SerializerFactory.class, "getSerializers", CodegenExpressionBuilder.constant(ExprNodeUtilityQuery.getExprResultTypes(this.nodes))));
        CodegenMethod method = parent.makeChild(Object.class, this.getClass(), (CodegenScope)classScope).addParam(EventBean.class, "eventBean");
        method.getBlock().declareVar(EventBean[].class, "events", CodegenExpressionBuilder.newArrayWithInit(EventBean.class, CodegenExpressionBuilder.ref("eventBean")));
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethod exprMethod = method.makeChildWithScope(Object.class, CodegenLegoMethodExpression.class, (CodegenSymbolProvider)exprSymbol, (CodegenScope)classScope).addParam(ExprForgeCodegenNames.PARAMS);
        CodegenExpression[] expressions = new CodegenExpression[this.nodes.length];
        for (i = 0; i < this.nodes.length; ++i) {
            expressions[i] = this.nodes[i].getForge().evaluateCodegen(this.nodes[i].getForge().getEvaluationType(), exprMethod, exprSymbol, classScope);
        }
        exprSymbol.derivedSymbolsCodegen(method, exprMethod.getBlock(), classScope);
        if (this.nodes.length == 1) {
            exprMethod.getBlock().methodReturn(expressions[0]);
        } else {
            exprMethod.getBlock().declareVar(Object[].class, "values", CodegenExpressionBuilder.newArrayByLength(Object.class, CodegenExpressionBuilder.constant(this.nodes.length)));
            for (i = 0; i < this.nodes.length; ++i) {
                CodegenExpression result = expressions[i];
                exprMethod.getBlock().assignArrayElement("values", CodegenExpressionBuilder.constant(i), result);
            }
            exprMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref("values"));
        }
        method.getBlock().declareVar(Object.class, "values", (CodegenExpression)CodegenExpressionBuilder.localMethod(exprMethod, CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constantNull())).methodReturn(CodegenExpressionBuilder.staticMethod(ContextControllerHashedGetterCRC32SerializedForge.class, "serializeAndCRC32Hash", CodegenExpressionBuilder.ref("values"), CodegenExpressionBuilder.constant(this.granularity), serializers));
        return CodegenExpressionBuilder.localMethod(method, beanExpression);
    }
}

