/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.hash;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.event.core.EventPropertyValueGetterForge;
import java.util.zip.CRC32;

public class ContextControllerHashedGetterCRC32SingleForge
implements EventPropertyValueGetterForge {
    private final ExprNode eval;
    private final int granularity;

    public ContextControllerHashedGetterCRC32SingleForge(ExprNode eval, int granularity) {
        this.eval = eval;
        this.granularity = granularity;
    }

    public static int stringToCRC32Hash(String code, int granularity) {
        long value;
        if (code == null) {
            value = 0L;
        } else {
            CRC32 crc = new CRC32();
            crc.update(code.getBytes());
            value = crc.getValue() % (long)granularity;
        }
        int result = (int)value;
        if (result >= 0) {
            return result;
        }
        return -result;
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(Object.class, this.getClass(), (CodegenScope)classScope).addParam(EventBean.class, "eventBean");
        CodegenMethod methodExpr = CodegenLegoMethodExpression.codegenExpression(this.eval.getForge(), method, classScope);
        method.getBlock().declareVar(EventBean[].class, "events", CodegenExpressionBuilder.newArrayWithInit(EventBean.class, CodegenExpressionBuilder.ref("eventBean"))).declareVar(String.class, "code", CodegenExpressionBuilder.cast(String.class, (CodegenExpression)CodegenExpressionBuilder.localMethod(methodExpr, CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constantNull()))).methodReturn(CodegenExpressionBuilder.staticMethod(ContextControllerHashedGetterCRC32SingleForge.class, "stringToCRC32Hash", CodegenExpressionBuilder.ref("code"), CodegenExpressionBuilder.constant(this.granularity)));
        return CodegenExpressionBuilder.localMethod(method, beanExpression);
    }
}

