/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.initterm;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionIdentifierInitiatedTerminated;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.common.client.context.ContextPartitionSelectorById;
import com.espertech.esper.common.client.context.ContextPartitionSelectorFiltered;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptor;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorFilter;
import com.espertech.esper.common.internal.context.controller.core.ContextController;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermFactory;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermPartitionKey;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermUtil;
import com.espertech.esper.common.internal.context.mgr.ContextControllerSelectorUtil;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionVisitor;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.function.BiConsumer;

public abstract class ContextControllerInitTerm
implements ContextController {
    protected final ContextControllerInitTermFactory factory;
    protected final ContextManagerRealization realization;

    public ContextControllerInitTerm(ContextControllerInitTermFactory factory, ContextManagerRealization realization) {
        this.factory = factory;
        this.realization = realization;
    }

    protected abstract void visitPartitions(IntSeqKey var1, BiConsumer<ContextControllerInitTermPartitionKey, Integer> var2);

    @Override
    public ContextControllerInitTermFactory getFactory() {
        return this.factory;
    }

    @Override
    public ContextManagerRealization getRealization() {
        return this.realization;
    }

    @Override
    public void visitSelectedPartitions(IntSeqKey path, ContextPartitionSelector selector, ContextPartitionVisitor visitor, ContextPartitionSelector[] selectorPerLevel) {
        if (selector instanceof ContextPartitionSelectorFiltered) {
            ContextPartitionSelectorFiltered filter = (ContextPartitionSelectorFiltered)selector;
            this.visitPartitions(path, (partitionKey, subpathOrCPIds) -> {
                ContextPartitionIdentifierInitiatedTerminated identifier = ContextControllerInitTermUtil.keyToIdentifier(subpathOrCPIds, partitionKey, this);
                if (filter.filter(identifier)) {
                    this.realization.contextPartitionRecursiveVisit(path, (int)subpathOrCPIds, this, visitor, selectorPerLevel);
                }
            });
            return;
        }
        if (selector instanceof ContextPartitionSelectorAll) {
            this.visitPartitions(path, (partitionKey, subpathOrCPIds) -> this.realization.contextPartitionRecursiveVisit(path, (int)subpathOrCPIds, this, visitor, selectorPerLevel));
            return;
        }
        if (selector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById byId = (ContextPartitionSelectorById)selector;
            this.visitPartitions(path, (hash, subpathOrCPId) -> {
                if (byId.getContextPartitionIds().contains(subpathOrCPId)) {
                    this.realization.contextPartitionRecursiveVisit(path, (int)subpathOrCPId, this, visitor, selectorPerLevel);
                }
            });
            return;
        }
        throw ContextControllerSelectorUtil.getInvalidSelector(new Class[0], selector);
    }

    public void populateEndConditionFromTrigger(MatchedEventMap map, EventBean triggeringEvent) {
        ContextConditionDescriptor start = this.factory.getInitTermSpec().getStartCondition();
        if (!(start instanceof ContextConditionDescriptorFilter)) {
            return;
        }
        ContextConditionDescriptorFilter filter = (ContextConditionDescriptorFilter)start;
        if (filter.getOptionalFilterAsName() == null) {
            return;
        }
        int tag = map.getMeta().getTagFor(filter.getOptionalFilterAsName());
        if (tag == -1) {
            return;
        }
        map.add(tag, triggeringEvent);
    }
}

