/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.initterm;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionCallback;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionFactory;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerEndConditionMatchEventProvider;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTerm;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermFactory;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermPartitionKey;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermSvc;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermSvcEntry;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermUtil;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionInstantiationResult;
import com.espertech.esper.common.internal.context.util.AgentInstance;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class ContextControllerInitTermBase
extends ContextControllerInitTerm
implements ContextControllerConditionCallback,
ContextControllerEndConditionMatchEventProvider {
    protected final ContextControllerInitTermSvc initTermSvc;

    public ContextControllerInitTermBase(ContextControllerInitTermFactory factory, ContextManagerRealization realization) {
        super(factory, realization);
        this.initTermSvc = ContextControllerInitTermUtil.getService(factory);
    }

    @Override
    public void deactivate(IntSeqKey path, boolean terminateChildContexts) {
        ContextControllerConditionNonHA initCondition = this.initTermSvc.mgmtDelete(path);
        if (initCondition != null && initCondition.isRunning()) {
            initCondition.deactivate();
        }
        Collection<ContextControllerInitTermSvcEntry> endConditions = this.initTermSvc.endDeleteByParentPath(path);
        for (ContextControllerInitTermSvcEntry entry : endConditions) {
            if (entry.getTerminationCondition().isRunning()) {
                entry.getTerminationCondition().deactivate();
            }
            if (!terminateChildContexts) continue;
            this.realization.contextPartitionTerminate(path, entry.getSubpathIdOrCPId(), this, null, false, null);
        }
    }

    @Override
    protected void visitPartitions(IntSeqKey controllerPath, BiConsumer<ContextControllerInitTermPartitionKey, Integer> partKeyAndCPId) {
        this.initTermSvc.endVisit(controllerPath, partKeyAndCPId);
    }

    @Override
    public void destroy() {
        this.initTermSvc.destroy();
    }

    List<AgentInstance> instantiateAndActivateEndCondition(IntSeqKey controllerPath, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, Map<String, Object> optionalPatternForInclusiveEval, ContextControllerConditionNonHA startCondition) {
        int subpathId = this.initTermSvc.mgmtUpdIncSubpath(controllerPath);
        IntSeqKey endConditionPath = controllerPath.addToEnd(subpathId);
        Object[] partitionKeys = this.initTermSvc.mgmtGetParentPartitionKeys(controllerPath);
        ContextControllerConditionNonHA endCondition = ContextControllerConditionFactory.getEndpoint(endConditionPath, partitionKeys, this.factory.initTermSpec.getEndCondition(), this, this, false);
        endCondition.activate(optionalTriggeringEvent, this);
        ContextControllerInitTermPartitionKey partitionKey = ContextControllerInitTermUtil.buildPartitionKey(optionalTriggeringEvent, optionalTriggeringPattern, endCondition, this);
        ContextPartitionInstantiationResult result = this.realization.contextPartitionInstantiate(controllerPath, subpathId, this, optionalTriggeringEvent, optionalPatternForInclusiveEval, partitionKeys, partitionKey);
        int subpathIdOrCPId = result.getSubpathOrCPId();
        this.initTermSvc.endCreate(endConditionPath, subpathIdOrCPId, endCondition, partitionKey);
        return result.getAgentInstances();
    }
}

