/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.initterm;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.collection.LRUCache;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionFactory;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermBase;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermDistinctSvc;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermDistinctSvcNested;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermDistinctSvcNonNested;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermFactory;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermSvcEntry;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermWDistinct;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.util.AgentInstance;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.FilterFaultHandler;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ContextControllerInitTermOverlap
extends ContextControllerInitTermBase
implements ContextControllerInitTermWDistinct {
    private final ContextControllerInitTermDistinctSvc distinctSvc;
    private final LRUCache<Object, EventBean> distinctLastTriggerEvents;
    private final EventBean[] eventsPerStreamDistinct;

    public ContextControllerInitTermOverlap(ContextControllerInitTermFactory factory, ContextManagerRealization realization) {
        super(factory, realization);
        if (factory.getInitTermSpec().getDistinctEval() != null) {
            this.distinctSvc = factory.getFactoryEnv().getNumNestingLevels() == 1 ? new ContextControllerInitTermDistinctSvcNonNested() : new ContextControllerInitTermDistinctSvcNested();
            this.eventsPerStreamDistinct = new EventBean[1];
            this.distinctLastTriggerEvents = new LRUCache(16);
        } else {
            this.distinctSvc = null;
            this.distinctLastTriggerEvents = null;
            this.eventsPerStreamDistinct = null;
        }
    }

    @Override
    public LRUCache<Object, EventBean> getDistinctLastTriggerEvents() {
        return this.distinctLastTriggerEvents;
    }

    @Override
    public void activate(IntSeqKey path, Object[] parentPartitionKeys, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern) {
        this.initTermSvc.mgmtCreate(path, parentPartitionKeys);
        ContextControllerConditionNonHA startCondition = ContextControllerConditionFactory.getEndpoint(path, parentPartitionKeys, this.factory.initTermSpec.getStartCondition(), this, this, true);
        boolean isTriggeringEventMatchesFilter = startCondition.activate(optionalTriggeringEvent, null);
        this.initTermSvc.mgmtUpdSetStartCondition(path, startCondition);
        if (isTriggeringEventMatchesFilter || startCondition.isImmediate()) {
            this.instantiateAndActivateEndCondition(path, optionalTriggeringEvent, optionalTriggeringPattern, optionalTriggeringPattern, startCondition);
        }
    }

    @Override
    public void deactivate(IntSeqKey path, boolean terminateChildContexts) {
        super.deactivate(path, terminateChildContexts);
        if (this.distinctSvc != null) {
            this.distinctSvc.clear(path);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.distinctSvc != null) {
            this.distinctSvc.destroy();
        }
    }

    @Override
    public void rangeNotification(IntSeqKey conditionPath, ContextControllerConditionNonHA originCondition, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, EventBean optionalTriggeringEventPattern, Map<String, Object> optionalPatternForInclusiveEval) {
        boolean endConditionNotification;
        boolean bl = endConditionNotification = originCondition.getDescriptor() != this.factory.getInitTermSpec().getStartCondition();
        if (endConditionNotification) {
            this.rangeNotificationEnd(conditionPath, originCondition, optionalTriggeringEvent, optionalTriggeringPattern, optionalTriggeringEventPattern);
        } else {
            this.rangeNotificationStart(conditionPath, originCondition, optionalTriggeringEvent, optionalTriggeringPattern, optionalTriggeringEventPattern);
        }
    }

    public ContextControllerInitTermDistinctSvc getDistinctSvc() {
        return this.distinctSvc;
    }

    private void rangeNotificationStart(IntSeqKey controllerPath, ContextControllerConditionNonHA startCondition, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, EventBean optionalTriggeringEventPattern) {
        boolean added;
        if (this.distinctSvc != null && !(added = this.addDistinctKey(controllerPath, optionalTriggeringEvent))) {
            return;
        }
        if (!startCondition.isRunning()) {
            startCondition.activate(optionalTriggeringEvent, null);
        }
        List<AgentInstance> agentInstances = this.instantiateAndActivateEndCondition(controllerPath, optionalTriggeringEvent, optionalTriggeringPattern, optionalTriggeringPattern, startCondition);
        this.installFilterFaultHandler(agentInstances, controllerPath);
    }

    private void rangeNotificationEnd(IntSeqKey conditionPath, ContextControllerConditionNonHA endCondition, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, EventBean optionalTriggeringEventPattern) {
        ContextControllerInitTermSvcEntry instance;
        if (endCondition.isRunning()) {
            endCondition.deactivate();
        }
        if ((instance = this.initTermSvc.endDelete(conditionPath)) == null) {
            return;
        }
        if (this.distinctSvc != null) {
            this.removeDistinctKey(conditionPath.removeFromEnd(), instance);
        }
        this.realization.contextPartitionTerminate(conditionPath.removeFromEnd(), instance.getSubpathIdOrCPId(), this, optionalTriggeringPattern, false, null);
    }

    private boolean addDistinctKey(IntSeqKey controllerPath, EventBean optionalTriggeringEvent) {
        if (optionalTriggeringEvent == null) {
            throw new IllegalStateException("No trgiggering event provided");
        }
        Object key = this.getDistinctKey(optionalTriggeringEvent);
        this.distinctLastTriggerEvents.put(key, optionalTriggeringEvent);
        return this.distinctSvc.addUnlessExists(controllerPath, key);
    }

    private void removeDistinctKey(IntSeqKey controllerPath, ContextControllerInitTermSvcEntry value) {
        EventBean event = value.getPartitionKey().getTriggeringEvent();
        Object key = this.getDistinctKey(event);
        this.distinctSvc.remove(controllerPath, key);
    }

    @Override
    public Object getDistinctKey(EventBean eventBean) {
        this.eventsPerStreamDistinct[0] = eventBean;
        return this.factory.getInitTermSpec().getDistinctEval().evaluate(this.eventsPerStreamDistinct, true, this.realization.getAgentInstanceContextCreate());
    }

    private void installFilterFaultHandler(List<AgentInstance> agentInstances, IntSeqKey controllerPath) {
        if (agentInstances.isEmpty()) {
            return;
        }
        if (this.distinctSvc == null) {
            return;
        }
        DistinctFilterFaultHandler myFaultHandler = new DistinctFilterFaultHandler(this, controllerPath);
        for (AgentInstance agentInstance : agentInstances) {
            agentInstance.getAgentInstanceContext().getEpStatementAgentInstanceHandle().setFilterFaultHandler(myFaultHandler);
        }
    }

    public static class DistinctFilterFaultHandler
    implements FilterFaultHandler {
        private final ContextControllerInitTermWDistinct contextControllerInitTerm;
        private final IntSeqKey controllerPath;

        public DistinctFilterFaultHandler(ContextControllerInitTermWDistinct contextControllerInitTerm, IntSeqKey controllerPath) {
            this.contextControllerInitTerm = contextControllerInitTerm;
            this.controllerPath = controllerPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleFilterFault(EventBean theEvent, long version) {
            AgentInstanceContext aiCreate = this.contextControllerInitTerm.getRealization().getAgentInstanceContextCreate();
            StatementAgentInstanceLock lock = aiCreate.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
            lock.acquireWriteLock();
            try {
                Object key = this.contextControllerInitTerm.getDistinctKey(theEvent);
                EventBean trigger = (EventBean)this.contextControllerInitTerm.getDistinctLastTriggerEvents().get(key);
                if (trigger != null) {
                    boolean bl = trigger.equals(theEvent);
                    return bl;
                }
                AgentInstanceUtil.evaluateEventForStatement(theEvent, null, Collections.singletonList(new AgentInstance(null, aiCreate, null)), aiCreate);
                boolean bl = true;
                return bl;
            }
            finally {
                lock.releaseWriteLock();
            }
        }
    }
}

