/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.keyed;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionIdentifierPartitioned;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.common.client.context.ContextPartitionSelectorById;
import com.espertech.esper.common.client.context.ContextPartitionSelectorFiltered;
import com.espertech.esper.common.client.context.ContextPartitionSelectorSegmented;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerBase;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedFactory;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedUtil;
import com.espertech.esper.common.internal.context.mgr.ContextControllerSelectorUtil;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionVisitor;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import java.util.function.BiConsumer;

public abstract class ContextControllerKeyed
extends ContextControllerBase {
    protected final ContextControllerKeyedFactory factory;
    protected EventBean lastTerminatingEvent;

    protected abstract void visitPartitions(IntSeqKey var1, BiConsumer<Object, Integer> var2);

    protected abstract int getSubpathOrCPId(IntSeqKey var1, Object var2);

    public ContextControllerKeyed(ContextManagerRealization realization, ContextControllerKeyedFactory factory) {
        super(realization);
        this.factory = factory;
    }

    public AgentInstanceContext getAgentInstanceContextCreate() {
        return this.realization.getAgentInstanceContextCreate();
    }

    @Override
    public ContextControllerKeyedFactory getFactory() {
        return this.factory;
    }

    @Override
    public ContextManagerRealization getRealization() {
        return this.realization;
    }

    @Override
    public void visitSelectedPartitions(IntSeqKey path, ContextPartitionSelector selector, ContextPartitionVisitor visitor, ContextPartitionSelector[] selectorPerLevel) {
        if (selector instanceof ContextPartitionSelectorSegmented) {
            ContextPartitionSelectorSegmented partitioned = (ContextPartitionSelectorSegmented)selector;
            if (partitioned.getPartitionKeys() == null || partitioned.getPartitionKeys().isEmpty()) {
                return;
            }
            for (Object[] key2 : partitioned.getPartitionKeys()) {
                Object keyForLookup = this.factory.getKeyedSpec().getMultiKeyFromObjectArray().from(key2);
                int subpathOrCPId2 = this.getSubpathOrCPId(path, keyForLookup);
                if (subpathOrCPId2 == -1) continue;
                this.realization.contextPartitionRecursiveVisit(path, subpathOrCPId2, this, visitor, selectorPerLevel);
            }
            return;
        }
        if (selector instanceof ContextPartitionSelectorFiltered) {
            ContextPartitionSelectorFiltered filtered = (ContextPartitionSelectorFiltered)selector;
            ContextPartitionIdentifierPartitioned identifier = new ContextPartitionIdentifierPartitioned();
            this.visitPartitions(path, (key, subpathOrCPId) -> {
                if (this.factory.getFactoryEnv().isLeaf()) {
                    identifier.setContextPartitionId((Integer)subpathOrCPId);
                }
                Object[] keys = ContextControllerKeyedUtil.unpackKey(key);
                identifier.setKeys(keys);
                if (filtered.filter(identifier)) {
                    this.realization.contextPartitionRecursiveVisit(path, (int)subpathOrCPId, this, visitor, selectorPerLevel);
                }
            });
            return;
        }
        if (selector instanceof ContextPartitionSelectorAll) {
            this.visitPartitions(path, (key, subpathOrCPId) -> this.realization.contextPartitionRecursiveVisit(path, (int)subpathOrCPId, this, visitor, selectorPerLevel));
            return;
        }
        if (selector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById ids = (ContextPartitionSelectorById)selector;
            this.visitPartitions(path, (key, subpathOrCPId) -> {
                if (ids.getContextPartitionIds().contains(subpathOrCPId)) {
                    this.realization.contextPartitionRecursiveVisit(path, (int)subpathOrCPId, this, visitor, selectorPerLevel);
                }
            });
        }
        throw ContextControllerSelectorUtil.getInvalidSelector(new Class[]{ContextPartitionSelectorSegmented.class}, selector);
    }
}

