/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.cpidsvc;

import com.espertech.esper.common.internal.context.cpidsvc.ContextPartitionIdService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ContextPartitionIdServiceImpl
implements ContextPartitionIdService {
    private final Map<Integer, Object[]> cpids = new HashMap<Integer, Object[]>();
    private int lastAssignedId = -1;

    @Override
    public void clear() {
        this.cpids.clear();
        this.lastAssignedId = -1;
    }

    @Override
    public Object[] getPartitionKeys(int id) {
        return this.cpids.get(id);
    }

    @Override
    public int allocateId(Object[] partitionKeys) {
        do {
            if (this.lastAssignedId < Integer.MAX_VALUE) {
                ++this.lastAssignedId;
                continue;
            }
            this.lastAssignedId = 0;
        } while (this.cpids.containsKey(this.lastAssignedId));
        this.cpids.put(this.lastAssignedId, partitionKeys);
        return this.lastAssignedId;
    }

    @Override
    public void removeId(int contextPartitionId) {
        this.cpids.remove(contextPartitionId);
    }

    @Override
    public Collection<Integer> getIds() {
        return new ArrayList<Integer>(this.cpids.keySet());
    }

    @Override
    public void destroy() {
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public long getCount() {
        return this.cpids.size();
    }
}

