/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.mgr;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.exception.ExceptionHandlerExceptionType;
import com.espertech.esper.common.internal.context.mgr.ContextStatementEventEvaluator;
import com.espertech.esper.common.internal.context.util.AgentInstance;
import com.espertech.esper.common.internal.context.util.AgentInstanceComparator;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackFilter;
import com.espertech.esper.common.internal.filtersvc.FilterHandle;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ContextStatementEventEvaluatorDefault
implements ContextStatementEventEvaluator {
    public static final ContextStatementEventEvaluatorDefault INSTANCE = new ContextStatementEventEvaluatorDefault();

    private ContextStatementEventEvaluatorDefault() {
    }

    @Override
    public void evaluateEventForStatement(EventBean theEvent, List<AgentInstance> agentInstances, AgentInstanceContext agentInstanceContextCreate) {
        ArrayDeque<FilterHandle> callbacks = new ArrayDeque<FilterHandle>(2);
        agentInstanceContextCreate.getFilterService().evaluate(theEvent, callbacks);
        if (callbacks.isEmpty()) {
            return;
        }
        if (agentInstances.size() == 1 && callbacks.size() == 1) {
            AgentInstance agentInstance = agentInstances.get(0);
            AgentInstanceContext agentInstanceContext = agentInstance.getAgentInstanceContext();
            FilterHandle callback = callbacks.getFirst();
            if (agentInstanceContext.getStatementId() == callback.getStatementId() && agentInstanceContext.getAgentInstanceId() == callback.getAgentInstanceId()) {
                ContextStatementEventEvaluatorDefault.process(agentInstance, callbacks, theEvent);
            }
            return;
        }
        boolean isPrioritized = agentInstanceContextCreate.getRuntimeSettingsService().getConfigurationRuntime().getExecution().isPrioritized();
        AbstractMap stmtCallbacks = !isPrioritized ? new HashMap() : new TreeMap(AgentInstanceComparator.INSTANCE);
        for (FilterHandle filterHandle : callbacks) {
            EPStatementHandleCallbackFilter handleCallback = (EPStatementHandleCallbackFilter)filterHandle;
            int statementId = filterHandle.getStatementId();
            AgentInstance agentInstanceFound = null;
            for (AgentInstance agentInstance : agentInstances) {
                AgentInstanceContext agentInstanceContext = agentInstance.getAgentInstanceContext();
                if (agentInstanceContext.getStatementId() != statementId || agentInstanceContext.getAgentInstanceId() != handleCallback.getAgentInstanceId()) continue;
                agentInstanceFound = agentInstance;
                break;
            }
            if (agentInstanceFound == null) continue;
            EPStatementAgentInstanceHandle handle = handleCallback.getAgentInstanceHandle();
            if (handle.isCanSelfJoin() || isPrioritized) {
                ArrayDeque<EPStatementHandleCallbackFilter> q;
                Object stmtCallback = stmtCallbacks.get(agentInstanceFound);
                if (stmtCallback == null) {
                    stmtCallbacks.put(agentInstanceFound, handleCallback);
                    continue;
                }
                if (stmtCallback instanceof ArrayDeque) {
                    q = (ArrayDeque<EPStatementHandleCallbackFilter>)stmtCallback;
                    if (q.contains(handleCallback)) continue;
                    q.add(handleCallback);
                    continue;
                }
                q = new ArrayDeque<EPStatementHandleCallbackFilter>(4);
                q.add((EPStatementHandleCallbackFilter)stmtCallback);
                if (stmtCallback != handleCallback) {
                    q.add(handleCallback);
                }
                stmtCallbacks.put(agentInstanceFound, q);
                continue;
            }
            ContextStatementEventEvaluatorDefault.process(agentInstanceFound, Collections.singletonList(handleCallback), theEvent);
        }
        if (stmtCallbacks.isEmpty()) {
            return;
        }
        for (Map.Entry entry : stmtCallbacks.entrySet()) {
            AgentInstance agentInstance = (AgentInstance)entry.getKey();
            Object callbackList = entry.getValue();
            if (callbackList instanceof ArrayDeque) {
                ContextStatementEventEvaluatorDefault.process(agentInstance, (Collection)callbackList, theEvent);
            } else {
                ContextStatementEventEvaluatorDefault.process(agentInstance, Collections.singletonList((FilterHandle)callbackList), theEvent);
            }
            if (!agentInstance.getAgentInstanceContext().getEpStatementAgentInstanceHandle().isPreemptive()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process(AgentInstance agentInstance, Collection<FilterHandle> callbacks, EventBean theEvent) {
        AgentInstanceContext agentInstanceContext = agentInstance.getAgentInstanceContext();
        agentInstance.getAgentInstanceContext().getAgentInstanceLock().acquireWriteLock();
        try {
            agentInstance.getAgentInstanceContext().getVariableManagementService().setLocalVersion();
            for (FilterHandle handle : callbacks) {
                EPStatementHandleCallbackFilter callback = (EPStatementHandleCallbackFilter)handle;
                if (callback.getAgentInstanceHandle() != agentInstanceContext.getEpStatementAgentInstanceHandle()) continue;
                callback.getFilterCallback().matchFound(theEvent, null);
            }
            agentInstanceContext.getEpStatementAgentInstanceHandle().internalDispatch();
        }
        catch (RuntimeException ex) {
            agentInstanceContext.getExceptionHandlingService().handleException(ex, agentInstanceContext.getEpStatementAgentInstanceHandle(), ExceptionHandlerExceptionType.PROCESS, theEvent);
        }
        finally {
            if (agentInstanceContext.getStatementContext().getEpStatementHandle().isHasTableAccess()) {
                agentInstanceContext.getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            agentInstanceContext.getAgentInstanceLock().releaseWriteLock();
        }
    }
}

