/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.module;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.eventtyperepo.EventTypeRepository;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class EventTypeCompileTimeRegistry {
    private final Map<String, EventType> moduleTypesAdded = new LinkedHashMap<String, EventType>();
    private final Map<String, EventType> newTypesAdded = new LinkedHashMap<String, EventType>();
    private final EventTypeRepository eventTypeRepositoryPreconfigured;

    public EventTypeCompileTimeRegistry(EventTypeRepository eventTypeRepositoryPreconfigured) {
        this.eventTypeRepositoryPreconfigured = eventTypeRepositoryPreconfigured;
    }

    public void newType(EventType type) {
        try {
            EventTypeUtility.validateModifiers(type.getName(), type.getMetadata().getBusModifier(), type.getMetadata().getAccessModifier());
        }
        catch (ExprValidationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (type.getMetadata().getAccessModifier() == NameAccessModifier.PRECONFIGURED) {
            if (type.getMetadata().getApplicationType() != EventTypeApplicationType.XML) {
                throw new IllegalArgumentException("Preconfigured-visibility is not allowed here");
            }
            this.eventTypeRepositoryPreconfigured.addType(type);
        }
        if (this.moduleTypesAdded.containsKey(type.getName())) {
            throw new IllegalArgumentException("Event type '" + type.getName() + "' has already been added by the module");
        }
        if (type.getMetadata().getAccessModifier() == NameAccessModifier.PRIVATE || type.getMetadata().getAccessModifier() == NameAccessModifier.PROTECTED || type.getMetadata().getAccessModifier() == NameAccessModifier.PUBLIC) {
            this.moduleTypesAdded.put(type.getName(), type);
        }
        if (this.newTypesAdded.containsKey(type.getName())) {
            throw new IllegalArgumentException("Event type '" + type.getName() + "' has already been added by the module");
        }
        this.newTypesAdded.put(type.getName(), type);
    }

    public EventType getModuleTypes(String typeName) {
        return this.moduleTypesAdded.get(typeName);
    }

    public Collection<EventType> getNewTypesAdded() {
        return this.newTypesAdded.values();
    }
}

